/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataEventEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataTypeRef;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionConfiguration;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MessageRowType {
    INPUT_PAYLOAD("input_payload", "Input: Payload"){

        @Override
        public void processMetadataDefinitionConfig(List<MetadataDefinitionConfiguration> configurations, MetadataEventEnricher inputEnricher, MetadataEventEnricher outputEnricher) {
            MetadataDefinitionConfiguration payloadConfiguration = configurations.get(0);
            MetadataTypeRef metadataTypeRef = MessageRowType.generateMetadataTypeRef(payloadConfiguration);
            inputEnricher.setPayload(metadataTypeRef);
        }

        @Override
        public List<MetadataDefinitionConfiguration> loadConfigFrom(Optional<MetadataEnricher> maybeEnricher) {
            MetadataTypeRef payloadRef;
            Optional inputEnricher;
            ArrayList<MetadataDefinitionConfiguration> configurations = new ArrayList<MetadataDefinitionConfiguration>();
            if (maybeEnricher.isPresent() && (inputEnricher = maybeEnricher.get().getInputEnricher()).isPresent() && !(payloadRef = ((MetadataEventEnricher)inputEnricher.get()).getPayload()).isNull()) {
                MetadataDefinitionConfiguration metadataDefinitionConfiguration = new MetadataDefinitionConfiguration();
                metadataDefinitionConfiguration.setId(this.getId());
                MessageRowType.fillMedatadaDefinition(metadataDefinitionConfiguration, payloadRef);
                configurations.add(metadataDefinitionConfiguration);
            }
            return configurations;
        }
    }
    ,
    INPUT_ATTRIBUTES("input_attributes", "Input: Attributes"){

        @Override
        public void processMetadataDefinitionConfig(List<MetadataDefinitionConfiguration> configurations, MetadataEventEnricher inputEnricher, MetadataEventEnricher outputEnricher) {
            MetadataDefinitionConfiguration attributesConfiguration = configurations.get(0);
            MetadataTypeRef metadataTypeRef = MessageRowType.generateMetadataTypeRef(attributesConfiguration);
            inputEnricher.setAttributes(metadataTypeRef);
        }

        @Override
        public List<MetadataDefinitionConfiguration> loadConfigFrom(Optional<MetadataEnricher> maybeEnricher) {
            MetadataTypeRef attributesRef;
            Optional inputEnricher;
            ArrayList<MetadataDefinitionConfiguration> configurations = new ArrayList<MetadataDefinitionConfiguration>();
            if (maybeEnricher.isPresent() && (inputEnricher = maybeEnricher.get().getInputEnricher()).isPresent() && !(attributesRef = ((MetadataEventEnricher)inputEnricher.get()).getAttributes()).isNull()) {
                MetadataDefinitionConfiguration metadataDefinitionConfiguration = new MetadataDefinitionConfiguration();
                metadataDefinitionConfiguration.setId(this.getId());
                MessageRowType.fillMedatadaDefinition(metadataDefinitionConfiguration, attributesRef);
                configurations.add(metadataDefinitionConfiguration);
            }
            return configurations;
        }
    }
    ,
    INPUT_VARIABLES("input_variables", "Input: Variables"){

        @Override
        public void processMetadataDefinitionConfig(List<MetadataDefinitionConfiguration> configurations, MetadataEventEnricher inputEnricher, MetadataEventEnricher outputEnricher) {
            MessageRowType.populateVariables(configurations, inputEnricher);
        }

        @Override
        public List<MetadataDefinitionConfiguration> loadConfigFrom(Optional<MetadataEnricher> maybeEnricher) {
            Optional inputEnricher;
            ArrayList<MetadataDefinitionConfiguration> configurations = new ArrayList<MetadataDefinitionConfiguration>();
            if (maybeEnricher.isPresent() && (inputEnricher = maybeEnricher.get().getInputEnricher()).isPresent()) {
                Map variables = ((MetadataEventEnricher)inputEnricher.get()).getVariables();
                MessageRowType.populateConfigurations(configurations, variables, this.getId());
            }
            return configurations;
        }
    }
    ,
    OUTPUT_PAYLOAD("output_payload", "Output: Payload"){

        @Override
        public void processMetadataDefinitionConfig(List<MetadataDefinitionConfiguration> configurations, MetadataEventEnricher inputEnricher, MetadataEventEnricher outputEnricher) {
            MetadataDefinitionConfiguration payloadConfiguration = configurations.get(0);
            MetadataTypeRef metadataTypeRef = MessageRowType.generateMetadataTypeRef(payloadConfiguration);
            outputEnricher.setPayload(metadataTypeRef);
        }

        @Override
        public List<MetadataDefinitionConfiguration> loadConfigFrom(Optional<MetadataEnricher> maybeEnricher) {
            MetadataTypeRef payloadRef;
            Optional outputEnricher;
            ArrayList<MetadataDefinitionConfiguration> configurations = new ArrayList<MetadataDefinitionConfiguration>();
            if (maybeEnricher.isPresent() && (outputEnricher = maybeEnricher.get().getOutputEnricher()).isPresent() && !(payloadRef = ((MetadataEventEnricher)outputEnricher.get()).getPayload()).isNull()) {
                MetadataDefinitionConfiguration metadataDefinitionConfiguration = new MetadataDefinitionConfiguration();
                metadataDefinitionConfiguration.setId(this.getId());
                MessageRowType.fillMedatadaDefinition(metadataDefinitionConfiguration, payloadRef);
                configurations.add(metadataDefinitionConfiguration);
            }
            return configurations;
        }
    }
    ,
    OUTPUT_ATTRIBUTES("output_attributes", "Output: Attributes"){

        @Override
        public void processMetadataDefinitionConfig(List<MetadataDefinitionConfiguration> configurations, MetadataEventEnricher inputEnricher, MetadataEventEnricher outputEnricher) {
            MetadataDefinitionConfiguration attributesConfiguration = configurations.get(0);
            MetadataTypeRef metadataTypeRef = MessageRowType.generateMetadataTypeRef(attributesConfiguration);
            outputEnricher.setAttributes(metadataTypeRef);
        }

        @Override
        public List<MetadataDefinitionConfiguration> loadConfigFrom(Optional<MetadataEnricher> maybeEnricher) {
            MetadataTypeRef attributesRef;
            Optional outputEnricher;
            ArrayList<MetadataDefinitionConfiguration> configurations = new ArrayList<MetadataDefinitionConfiguration>();
            if (maybeEnricher.isPresent() && (outputEnricher = maybeEnricher.get().getOutputEnricher()).isPresent() && !(attributesRef = ((MetadataEventEnricher)outputEnricher.get()).getAttributes()).isNull()) {
                MetadataDefinitionConfiguration metadataDefinitionConfiguration = new MetadataDefinitionConfiguration();
                metadataDefinitionConfiguration.setId(this.getId());
                MessageRowType.fillMedatadaDefinition(metadataDefinitionConfiguration, attributesRef);
                configurations.add(metadataDefinitionConfiguration);
            }
            return configurations;
        }
    }
    ,
    OUTPUT_VARIABLES("output_variables", "Output: Variables"){

        @Override
        public void processMetadataDefinitionConfig(List<MetadataDefinitionConfiguration> configurations, MetadataEventEnricher inputEnricher, MetadataEventEnricher outputEnricher) {
            MessageRowType.populateVariables(configurations, outputEnricher);
        }

        @Override
        public List<MetadataDefinitionConfiguration> loadConfigFrom(Optional<MetadataEnricher> maybeEnricher) {
            Optional outputEnricher;
            ArrayList<MetadataDefinitionConfiguration> configurations = new ArrayList<MetadataDefinitionConfiguration>();
            if (maybeEnricher.isPresent() && (outputEnricher = maybeEnricher.get().getOutputEnricher()).isPresent()) {
                Map variables = ((MetadataEventEnricher)outputEnricher.get()).getVariables();
                MessageRowType.populateConfigurations(configurations, variables, this.getId());
            }
            return configurations;
        }
    };

    private String id;
    private String displayName;
    public static final List<MessageRowType> OUTPUT_ROW_TYPES;
    public static final List<MessageRowType> INPUT_ROW_TYPES;

    static {
        OUTPUT_ROW_TYPES = Arrays.asList(OUTPUT_ATTRIBUTES, OUTPUT_PAYLOAD, OUTPUT_VARIABLES);
        INPUT_ROW_TYPES = Arrays.asList(INPUT_ATTRIBUTES, INPUT_PAYLOAD, INPUT_VARIABLES);
    }

    private MessageRowType(String id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static MessageRowType value(String id) {
        MessageRowType[] messageRowTypeArray = MessageRowType.values();
        int n = messageRowTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageRowType type = messageRowTypeArray[n2];
            if (type.getId().equals(id)) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    private static MetadataTypeRef generateMetadataTypeRef(MetadataDefinitionConfiguration configuration) {
        String key = configuration.getKey();
        String module = configuration.getModule();
        MetadataTypeRef.MetadataTypeRefBuilder metadataTypeRefBuilder = MetadataTypeRef.builder();
        if (StringUtils.isNotBlank((String)module) && StringUtils.isNotBlank((String)key)) {
            metadataTypeRefBuilder = configuration.isCollection() ? metadataTypeRefBuilder.withModule(module).withKey(key).asCollection() : metadataTypeRefBuilder.withModule(module).withKey(key);
        }
        return metadataTypeRefBuilder.build();
    }

    private static void populateVariables(List<MetadataDefinitionConfiguration> configurations, MetadataEventEnricher metadataEventEnricher) {
        for (MetadataDefinitionConfiguration configuration : configurations) {
            MetadataTypeRef variableRef;
            String variableName = configuration.getVariableName();
            if (!StringUtils.isNotBlank((String)variableName) || (variableRef = MessageRowType.generateMetadataTypeRef(configuration)).isNull()) continue;
            metadataEventEnricher.addVariable(variableName, variableRef);
        }
    }

    private static void populateConfigurations(List<MetadataDefinitionConfiguration> configurations, Map<String, MetadataTypeRef> variables, String id) {
        if (variables != null) {
            for (Map.Entry<String, MetadataTypeRef> entry : variables.entrySet()) {
                MetadataDefinitionConfiguration metadataDefinitionConfiguration = new MetadataDefinitionConfiguration();
                metadataDefinitionConfiguration.setId(id);
                metadataDefinitionConfiguration.setVariableName(entry.getKey());
                MessageRowType.fillMedatadaDefinition(metadataDefinitionConfiguration, entry.getValue());
                configurations.add(metadataDefinitionConfiguration);
            }
        }
    }

    private static void fillMedatadaDefinition(MetadataDefinitionConfiguration metadataDefinitionConfiguration, MetadataTypeRef metadataTypeRef) {
        if (metadataTypeRef.isCollection()) {
            metadataDefinitionConfiguration.setModule(metadataTypeRef.getModule());
            metadataDefinitionConfiguration.setKey(metadataTypeRef.getKey());
            metadataDefinitionConfiguration.setCollection(metadataTypeRef.isCollection());
        } else {
            metadataDefinitionConfiguration.setModule(metadataTypeRef.getModule());
            metadataDefinitionConfiguration.setKey(metadataTypeRef.getKey());
        }
    }

    public boolean isOutput() {
        return OUTPUT_ROW_TYPES.contains((Object)this);
    }

    public boolean isInput() {
        return INPUT_ROW_TYPES.contains((Object)this);
    }

    public abstract void processMetadataDefinitionConfig(List<MetadataDefinitionConfiguration> var1, MetadataEventEnricher var2, MetadataEventEnricher var3);

    public abstract List<MetadataDefinitionConfiguration> loadConfigFrom(Optional<MetadataEnricher> var1);
}

