/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IDataSenseTypeChangedListener;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.ui.MuleImages;
import org.mule.tooling.ui.modules.core.metadata.definition.AbstractDynamicContent;
import org.mule.tooling.ui.modules.core.metadata.definition.IDefinitionChangedListener;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionConfiguration;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizard;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataDefinitionWizardDialog;
import org.mule.tooling.ui.widgets.dynamic.table.TablePersistenceStrategy;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MessageMetadataEditor
extends AbstractDynamicContent {
    private Composite editorWrapper;
    private EventBusHelper eventBusHelper;

    public MessageMetadataEditor(IMuleProject muleProject, EventBus eventBus) {
        super(muleProject, eventBus);
    }

    public void createControls(Composite parent) {
        this.container = parent;
        this.editorWrapper = new Composite(this.container, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.editorWrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.editorWrapper);
        this.selectedStructureLabel = new CLabel(this.editorWrapper, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.selectedStructureLabel);
        this.selectedStructureLabel.setText("Unknown");
        ToolBar fieldToolBar = new ToolBar(this.editorWrapper, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(1, 0x1000000).applyTo((Control)fieldToolBar);
        ToolBarManager fieldTBManager = new ToolBarManager(fieldToolBar);
        SelectMetadataAction add = new SelectMetadataAction();
        fieldTBManager.add((IAction)add);
        fieldTBManager.update(true);
        this.eventBusHelper = new EventBusHelper();
        this.eventBusHelper.registerUIListener(this.eventBus, CoreEventTypes.ON_DATASENSE_TYPE_CHANGE_EVENT, (IEventHandler)new IDataSenseTypeChangedListener(){

            public void onDataSenseTypesChanged(IMuleProject project) {
                MessageMetadataEditor.this.updateLabel();
            }
        });
        this.editorWrapper.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MessageMetadataEditor.this.eventBusHelper.unregister();
            }
        });
    }

    public TablePersistenceStrategy<MetadataDefinitionConfiguration> getPersistenceStrategy() {
        return new MessagePersistenceStrategy();
    }

    private void notifyDefinitionChange() {
        this.eventBus.fireEvent((IEvent)new IEvent<IDefinitionChangedListener>(){

            public EventType<IDefinitionChangedListener> getAssociatedType() {
                return IDefinitionChangedListener.ON_DEFINITION_CHANGE;
            }

            public void dispatch(IDefinitionChangedListener handler) {
                handler.contentChange();
            }
        });
    }

    private class MessagePersistenceStrategy
    implements TablePersistenceStrategy<MetadataDefinitionConfiguration> {
        private MessagePersistenceStrategy() {
        }

        public MetadataDefinitionConfiguration save() {
            MetadataDefinitionConfiguration configuration = new MetadataDefinitionConfiguration();
            configuration.setKey(MessageMetadataEditor.this.metadataResult.getKey());
            configuration.setModule(MessageMetadataEditor.this.metadataResult.getModule());
            configuration.setCollection(MessageMetadataEditor.this.metadataResult.isCollection());
            return configuration;
        }

        public void load(MetadataDefinitionConfiguration parameters) {
            MessageMetadataEditor.this.metadataResult.setKey(parameters.getKey());
            MessageMetadataEditor.this.metadataResult.setModule(parameters.getModule());
            MessageMetadataEditor.this.metadataResult.setIsCollection(parameters.isCollection());
            MessageMetadataEditor.this.updateLabel();
        }
    }

    private class SelectMetadataAction
    extends Action {
        public SelectMetadataAction() {
            this.setImageDescriptor(MuleImages.DESC_EDIT);
            this.setText("edit");
        }

        public void run() {
            MetadataDefinitionWizard wizard = new MetadataDefinitionWizard(MessageMetadataEditor.this.getMuleProject());
            Shell activeShell = Display.getCurrent().getActiveShell();
            MetadataDefinitionWizardDialog dialog = new MetadataDefinitionWizardDialog(activeShell, wizard);
            if (dialog.open() == 0) {
                MessageMetadataEditor.this.metadataResult = wizard.getResult();
                MessageMetadataEditor.this.updateLabel();
                MessageMetadataEditor.this.notifyDefinitionChange();
            }
        }
    }
}

