/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.definition;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.ui.modules.core.metadata.definition.MetadataResult;
import org.mule.tooling.ui.widgets.WidgetsImages;
import org.mule.tooling.ui.widgets.dynamic.table.DynamicContent;
import org.mule.tooling.utils.eventbus.EventBus;

public abstract class AbstractDynamicContent
implements DynamicContent {
    protected static final String UNKNOWN_LABEL = "Unknown";
    protected CLabel selectedStructureLabel;
    protected MetadataResult metadataResult;
    protected IMuleProject muleProject;
    protected Composite container;
    protected EventBus eventBus;

    public AbstractDynamicContent(IMuleProject muleProject, EventBus eventBus) {
        this.muleProject = muleProject;
        this.eventBus = eventBus;
        this.metadataResult = MetadataResult.createEmpty();
    }

    protected void updateLabel() {
        boolean isMetadataDefined;
        String module = this.metadataResult.getModule();
        String metadataKey = this.metadataResult.getKey();
        String categoryId = "#Default Category#";
        boolean bl = isMetadataDefined = StringUtils.isNotBlank((String)module) && StringUtils.isNotBlank((String)metadataKey);
        if (isMetadataDefined) {
            MetadataKey key;
            ITypesManager typesManager = ((MetadataTypesManager)this.getMuleProject().getProjectComponent(MetadataTypesManager.class)).getTypesManager();
            MetadataType metadataKeyStructure = typesManager.getMetadataType(module, categoryId, key = typesManager.getMetadataKeyByName(module, categoryId, metadataKey));
            this.selectedStructureLabel.setImage(metadataKeyStructure == null ? WidgetsImages.getImage((String)"/icons/notification/warning-16x16.png") : null);
            this.selectedStructureLabel.setToolTipText(metadataKeyStructure == null ? "Type does not exist" : null);
            this.selectedStructureLabel.setText(this.getTypeLabel() + this.getKeyLabel());
        } else {
            this.selectedStructureLabel.setText(UNKNOWN_LABEL);
        }
        this.selectedStructureLabel.redraw();
        this.container.layout(true, true);
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    private String getKeyLabel() {
        if (this.metadataResult.isCollection()) {
            return "Array of " + this.metadataResult.getKey();
        }
        return this.isAutogeneratedMetadata() ? "" : "/" + this.metadataResult.getKey();
    }

    private boolean isAutogeneratedMetadata() {
        return this.metadataResult.getKey().startsWith("auto_") || this.metadataResult.getMetadataType() != null && this.metadataResult.getMetadataType().getAnnotation(AutogeneratedAnnotation.class).isPresent();
    }

    private String getTypeLabel() {
        boolean isCustom = "#Custom Type#".equals(this.metadataResult.getModule());
        if (this.isAutogeneratedMetadata()) {
            return "Autogenerated";
        }
        if (isCustom) {
            return "User Defined";
        }
        boolean isDefault = MetadataUtils.DEFAULT_OPERATION_TYPE_KEY.equals(this.metadataResult.getModule());
        return isDefault ? "Default Type" : this.metadataResult.getModule();
    }
}

