/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.action;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.client.MetadataKeysServiceExecutor;
import org.mule.tooling.client.api.ServiceResponse;
import org.mule.tooling.client.api.metadata.FailureCode;
import org.mule.tooling.client.api.metadata.MetadataFailure;
import org.mule.tooling.client.api.metadata.MetadataKeysContainer;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;
import org.mule.tooling.ui.modules.core.metadata.action.DataSenseOperation;
import org.mule.tooling.ui.modules.core.metadata.notifications.DataSenseJobNotificationsUtils;
import org.mule.tooling.ui.modules.core.widgets.editors.options.CompletionEvent;
import org.mule.tooling.utils.eventbus.IEvent;

public class GetMetadataKeysExecutor
extends DataSenseOperation<MetadataResult<ServiceResponse<MetadataKeysContainer>>> {
    private final String elementName;
    private final String componentPath;
    private final IMessageFlowNode originalNode;
    private final Supplier<IMessageFlowNode> newMessageFlowNodeSupplier;
    private final Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider;
    private final String editorId;
    private final String category;

    public GetMetadataKeysExecutor(IMuleProject muleProject, MuleConfiguration muleConfiguration, IMessageFlowNode messageFlowNode, boolean showEditLinkIfError, String componentPath, String editorId, String category) {
        this(muleProject, muleConfiguration, messageFlowNode, messageFlowNode, showEditLinkIfError, componentPath, componentPath, () -> messageFlowNode, x -> messageFlowNode.getProperties().toPropertyCollectionMap(), editorId, category);
    }

    public GetMetadataKeysExecutor(IMuleProject muleProject, MuleConfiguration muleConfiguration, IMessageFlowNode originalNode, IMessageFlowNode messageFlowNode, boolean showEditLinkIfError, String elementName, String componentPath, Supplier<IMessageFlowNode> newMessageFlowNodeSupplier, Function<IMessageFlowNode, PropertyCollectionMap> updatedPropertiesProvider, String editorID, String category) {
        super(muleProject, muleConfiguration, messageFlowNode, showEditLinkIfError);
        this.elementName = elementName;
        this.componentPath = componentPath;
        this.originalNode = originalNode;
        this.newMessageFlowNodeSupplier = newMessageFlowNodeSupplier;
        this.updatedPropertiesProvider = updatedPropertiesProvider;
        this.editorId = editorID;
        this.category = category;
    }

    @Override
    public String getJobName() {
        return "Fetching metadata keys";
    }

    @Override
    public String getInfoMessage() {
        return "Retrieving" + this.getNodeName() + "list of Metadata keys...";
    }

    @Override
    public String getErrorMessage() {
        return "Error retrieving list of Metadata keys...";
    }

    @Override
    public MetadataResult<ServiceResponse<MetadataKeysContainer>> execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        MetadataResult result = null;
        try {
            result = this.getMetadataKeys();
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Metadata keys retrieval failed for global element ", (Throwable)e);
            result = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(e.getCause() != null ? e.getCause().getMessage() : e.getMessage()).withFailureCode(new FailureCode("UNKNOWN")).withReason(ExceptionUtils.getStackTrace((Throwable)e)).onComponent()});
        }
        return result;
    }

    protected MetadataResult<ServiceResponse<MetadataKeysContainer>> getMetadataKeys() throws Exception {
        MetadataKeysServiceExecutor metadataKeyService = ((MetadataKeysServiceExecutor.MetadataKeysExecutorBuilder)((MetadataKeysServiceExecutor.MetadataKeysExecutorBuilder)((MetadataKeysServiceExecutor.MetadataKeysExecutorBuilder)((MetadataKeysServiceExecutor.MetadataKeysExecutorBuilder)((MetadataKeysServiceExecutor.MetadataKeysExecutorBuilder)((MetadataKeysServiceExecutor.MetadataKeysExecutorBuilder)((MetadataKeysServiceExecutor.MetadataKeysExecutorBuilder)((MetadataKeysServiceExecutor.MetadataKeysExecutorBuilder)MetadataKeysServiceExecutor.newBuilder().toolingWorkspace(ToolingWorkspace.getInstance())).muleInstance(ToolingManager.getInstance().getToolingInstance())).project(this.getMuleProject())).muleConfiguration(this.getMuleConfiguration())).generalErrorMessage(this.getErrorMessage())).componentLocation(this.componentPath).messageFlowNode(this.originalNode)).newMessageFlowNodeSupplier(this.getNewMessageFlowNodeSupplier())).updatedPropertiesProvider(this.getUpdatedPropertiesProvider())).build();
        ServiceResponse result = metadataKeyService.runServiceRequest();
        return MetadataResult.success((Object)result);
    }

    private Supplier<IMessageFlowNode> getNewMessageFlowNodeSupplier() {
        return this.newMessageFlowNodeSupplier;
    }

    private Function<IMessageFlowNode, PropertyCollectionMap> getUpdatedPropertiesProvider() {
        return this.updatedPropertiesProvider;
    }

    @Override
    public void handleResult(MetadataResult<ServiceResponse<MetadataKeysContainer>> result) {
        if (result != null && ((ServiceResponse)result.get()).isSuccess()) {
            MetadataKeysContainer metadataKeysContainer = (MetadataKeysContainer)((ServiceResponse)result.get()).getResult();
            if (metadataKeysContainer != null) {
                Map keysByCategory = metadataKeysContainer.getKeysByCategory();
                ITypesManager typesManager = ((MetadataTypesManager)this.getMuleProject().getProjectComponent(MetadataTypesManager.class)).getTypesManager();
                keysByCategory.entrySet().forEach(pair -> typesManager.setMetadataKeys(this.elementName, (String)pair.getKey(), (Set)pair.getValue()));
                if (!typesManager.getMetadataKeys(this.elementName, this.category).isEmpty() && this.editorId != null) {
                    MuleCorePlugin.getEventBus().fireEvent((IEvent)new CompletionEvent(this.editorId));
                }
            }
        } else if (result != null) {
            MetadataFailure metadataFailure = (MetadataFailure)result.getFailures().get(0);
            FailureCode failureCode = metadataFailure.getFailureCode();
            String message = failureCode.getValue();
            DataSenseJobNotificationsUtils.openErrorNotification(message, metadataFailure.getReason(), this);
        } else {
            DataSenseJobNotificationsUtils.openErrorNotification("Retrieve list of keys failed for element: " + this.elementName, "Retrieval failure. Please check the connector configuration.", null);
        }
    }

    private String getNodeName() {
        IMessageFlowNode node = this.getMessageFlowNode();
        boolean hasName = node != null && !StringUtils.isBlank((String)node.getName());
        return hasName ? " " + node.getName() + " " : " this connector's ";
    }

    @Override
    public IMessageFlowNode getMessageFlowNode() {
        return this.originalNode;
    }
}

