/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.action;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.mule.tooling.client.api.metadata.FailureCode;
import org.mule.tooling.client.api.metadata.MetadataFailure;
import org.mule.tooling.client.api.metadata.MetadataKeysContainer;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.metadata.api.impl.DefaultMetadataKeysRetriever;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.runtime.tooling.ToolingProject;
import org.mule.tooling.runtime.tooling.ToolingProjectsCache;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;
import org.mule.tooling.ui.modules.core.metadata.action.DataSenseOperation;
import org.mule.tooling.ui.modules.core.metadata.notifications.DataSenseJobNotificationsUtils;

@Deprecated
public class GetMetadataKeys
extends DataSenseOperation<MetadataResult<MetadataKeysContainer>> {
    private final String elementName;
    private final String componentPath;

    public GetMetadataKeys(IMuleProject muleProject, MuleConfiguration muleConfiguration, IMessageFlowNode messageFlowNode, boolean showEditLinkIfError) {
        super(muleProject, muleConfiguration, messageFlowNode, showEditLinkIfError);
        String globalElementName;
        this.elementName = globalElementName = CoreUtils.getNameProperty((IMessageFlowNode)messageFlowNode);
        this.componentPath = globalElementName;
    }

    public GetMetadataKeys(IMuleProject muleProject, MuleConfiguration muleConfiguration, IMessageFlowNode messageFlowNode, boolean showEditLinkIfError, String elementName, String componentPath) {
        super(muleProject, muleConfiguration, messageFlowNode, showEditLinkIfError);
        this.elementName = elementName;
        this.componentPath = componentPath;
    }

    @Override
    public String getJobName() {
        return "Fetching metadata keys";
    }

    @Override
    public String getInfoMessage() {
        return "Retrieving" + this.getNodeName() + "list of Metadata keys...";
    }

    @Override
    public String getErrorMessage() {
        return "Error retrieving list of Metadata keys...";
    }

    @Override
    public MetadataResult<MetadataKeysContainer> execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        MetadataResult<MetadataKeysContainer> result = null;
        final ToolingWorkspace toolingWorkspace = ToolingWorkspace.getInstance();
        final QualifiedName name = new QualifiedName(null, "install");
        try (ToolingProject toolingProject = null;){
            try {
                WorkspaceJob install = new WorkspaceJob("Install Project in Tooling"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        try {
                            ToolingProject toolingProject = toolingWorkspace.install(GetMetadataKeys.this.getMuleProject());
                            this.setProperty(name, toolingProject);
                        }
                        catch (IOException | CoreException throwable) {
                            MuleCorePlugin.logError((String)("Failed to install project: " + String.valueOf(GetMetadataKeys.this.getMuleProject()) + " in Tooling"));
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                install.setRule((ISchedulingRule)this.getMuleProject().getProject());
                install.schedule();
                install.join();
                toolingProject = (ToolingProject)install.getProperty(name);
                if (toolingProject == null) {
                    throw new CoreException((IStatus)ToolingProjectsCache.getFailureStatus((IMuleProject)this.getMuleProject()));
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                result = this.getMetadataKeys(toolingProject);
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)"Metadata keys retrieval failed for global element ", (Throwable)e);
                result = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure().withMessage(e.getCause() != null ? e.getCause().getMessage() : e.getMessage()).withFailureCode(new FailureCode("UNKNOWN")).withReason(ExceptionUtils.getStackTrace((Throwable)e)).onComponent()});
                if (toolingProject != null) {
                    toolingProject.close();
                }
            }
        }
        return result;
    }

    protected MetadataResult<MetadataKeysContainer> getMetadataKeys(ToolingProject toolingProject) throws Exception {
        MetadataResult result = new DefaultMetadataKeysRetriever().getMetadataKeys(toolingProject, this.getMuleConfiguration(), this.getMessageFlowNode(), this.componentPath);
        return result;
    }

    @Override
    public void handleResult(MetadataResult<MetadataKeysContainer> result) {
        if (result != null && result.isSuccess()) {
            MetadataKeysContainer metadataKeysContainer = (MetadataKeysContainer)result.get();
            if (metadataKeysContainer != null) {
                Map keysByCategory = metadataKeysContainer.getKeysByCategory();
                ITypesManager typesManager = ((MetadataTypesManager)this.getMuleProject().getProjectComponent(MetadataTypesManager.class)).getTypesManager();
                keysByCategory.entrySet().forEach(pair -> typesManager.setMetadataKeys(this.elementName, (String)pair.getKey(), (Set)pair.getValue()));
            }
        } else if (result != null) {
            MetadataFailure metadataFailure = (MetadataFailure)result.getFailures().get(0);
            FailureCode failureCode = metadataFailure.getFailureCode();
            String message = failureCode.getValue();
            DataSenseJobNotificationsUtils.openErrorNotification(message, metadataFailure.getReason(), this);
        } else {
            DataSenseJobNotificationsUtils.openErrorNotification("Retrieve list of keys failed for element: " + this.elementName, "Retrieval failure. Please check the connector configuration.", null);
        }
    }

    private String getNodeName() {
        IMessageFlowNode node = this.getMessageFlowNode();
        boolean hasName = node != null && !StringUtils.isBlank((String)node.getName());
        return hasName ? " " + node.getName() + " " : " this connector's ";
    }
}

