/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata.action;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.mule.tooling.client.api.metadata.MetadataResult;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.preferences.MuleStudioPreference;

public abstract class DataSenseOperation<R extends MetadataResult<?>>
implements IRunnableWithProgress {
    private IMuleProject muleProject;
    private MuleConfiguration muleConfiguration;
    private IMessageFlowNode messageFlowNode;
    private boolean showEditLinkIfError;
    private R result;

    public DataSenseOperation(IMuleProject muleProject, MuleConfiguration muleConfiguration, IMessageFlowNode messageFlowNode) {
        this(muleProject, muleConfiguration, messageFlowNode, false);
    }

    public DataSenseOperation(IMuleProject muleProject, MuleConfiguration muleConfiguration, IMessageFlowNode messageFlowNode, boolean showEditLinkIfError) {
        this.muleProject = muleProject;
        this.muleConfiguration = muleConfiguration;
        this.messageFlowNode = messageFlowNode;
        this.showEditLinkIfError = showEditLinkIfError;
    }

    public abstract String getJobName();

    public abstract String getInfoMessage();

    public abstract String getErrorMessage();

    public abstract R execute(IProgressMonitor var1) throws InvocationTargetException, InterruptedException;

    public abstract void handleResult(R var1);

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.result = this.execute(monitor);
        this.handleResult(this.result);
    }

    public R getResult() {
        return this.result;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }

    public IMessageFlowNode getMessageFlowNode() {
        return this.messageFlowNode;
    }

    public boolean showEditLinkIfError() {
        return this.showEditLinkIfError;
    }

    public int getTimeout() {
        return MuleStudioPreference.getDatasenseTimeoutInSeconds();
    }
}

