/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.dialog.IDialogController;
import org.mule.tooling.messageflow.dialog.ISimpleHost;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.runtime.tooling.ToolingProject;
import org.mule.tooling.runtime.tooling.ToolingProjectFile;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.metadata.MetadataStatus;
import org.mule.tooling.ui.modules.core.metadata.action.GetMetadataKeysTooling;
import org.mule.tooling.ui.modules.core.metadata.queue.DataSenseProcessorQueue;

public class UseMetadataDialogController
implements IDialogController {
    public boolean doUpdate(ISimpleHost pageHost, PropertyCollectionMap map, NodeDefinition definition, IMuleProject muleProject, MuleConfiguration configuration) {
        MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
        if (flowEditorFromActivePage != null) {
            MuleConfigurationDecorator modelRoot = flowEditorFromActivePage.getModelRoot();
            MuleConfiguration muleConfiguration = configuration == null ? (MuleConfiguration)modelRoot.getEntity() : configuration;
            IMuleProject globalMuleProject = flowEditorFromActivePage.getMuleProject();
            if (this.allPropertiesRequiredForDatasenseArePresent(definition, pageHost, muleProject)) {
                this.retrieveMetadataKeys(pageHost, muleProject, muleConfiguration, globalMuleProject);
            }
        }
        return true;
    }

    private boolean allPropertiesRequiredForDatasenseArePresent(NodeDefinition definition, ISimpleHost pageHost, IMuleProject muleProject) {
        Supplier newMessageFlowNodeSupplier = MessageFlowUtils.generateNodeToTestSupplier((IMessageFlowNode)pageHost.getNode());
        Function updatedPropertiesProvider = MessageFlowUtils.updatedPropertiesProvider((List)pageHost.getContributedPages());
        IMessageFlowNode updatedNode = (IMessageFlowNode)newMessageFlowNodeSupplier.get();
        PropertyCollectionMap updatedProperties = (PropertyCollectionMap)updatedPropertiesProvider.apply(updatedNode);
        MetadataStatus metadataStatus = MetadataHelpers.getMetadataStatus(updatedNode);
        return metadataStatus == MetadataStatus.DYNAMIC && MetadataHelpers.areDataSenseRequirementsFulfilled(definition, updatedProperties, muleProject);
    }

    protected void retrieveMetadataKeys(ISimpleHost pageHost, IMuleProject muleProject, MuleConfiguration muleConfiguration, IMuleProject globalMuleProject) {
        ToolingWorkspace toolingWorkspace = ToolingWorkspace.getInstance();
        try {
            IMessageFlowNode updatedMessageFlowNode;
            ToolingProject toolingProject = toolingWorkspace.install(muleProject);
            IMessageFlowNode messageFlowNode = pageHost.getNode();
            Supplier newMessageFlowNodeSupplier = MessageFlowUtils.generateNodeToTestSupplier((IMessageFlowNode)messageFlowNode);
            Function updatedPropertiesProvider = MessageFlowUtils.updatedPropertiesProvider((List)pageHost.getContributedPages());
            Optional maybeToolingProjectFile = toolingProject.getProjectFile(muleConfiguration);
            if (maybeToolingProjectFile.isPresent() && MetadataHelpers.usesMetadataKeys(updatedMessageFlowNode = ((ToolingProjectFile)maybeToolingProjectFile.get()).saveElement(messageFlowNode, newMessageFlowNodeSupplier, updatedPropertiesProvider))) {
                String globalElementName = CoreUtils.getNameProperty((IMessageFlowNode)updatedMessageFlowNode);
                Set metadataKeys = ((MetadataTypesManager)muleProject.getProjectComponent(MetadataTypesManager.class)).getTypesManager().getMetadataKeys(globalElementName, "#Default Category#");
                GetMetadataKeysTooling dataSenseOperation = new GetMetadataKeysTooling(toolingProject, globalMuleProject, muleConfiguration, updatedMessageFlowNode, true, globalElementName);
                if (metadataKeys.isEmpty()) {
                    DataSenseProcessorQueue.getInstance().queue(dataSenseOperation);
                }
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error while preparing tooling application", (Throwable)e);
        }
    }
}

