/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.metadata.MetadataKeyDisplay;
import org.mule.tooling.ui.modules.core.metadata.MetadataRequestContext;
import org.mule.tooling.ui.modules.core.metadata.action.GetMetadataKeysExecutor;
import org.mule.tooling.ui.modules.core.metadata.queue.DataSenseProcessorQueue;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class MetadataRetrievalManager {
    private MetadataRetrievalManager() {
        throw new IllegalAccessError("Not intended to be accesed");
    }

    public static List<EnumOption> getEnumOptionsMetadataKeys(MetadataRequestContext metadataRequestContext) {
        List<EnumOption> retrievedEnumOptionsKeys;
        String category = MetadataHelpers.getMessageFlowCategory(metadataRequestContext.getUpdatedNode());
        List<MetadataKey> metadataKeys = MetadataRetrievalManager.retrieveMetadataKeys(metadataRequestContext, category);
        if (metadataKeys != null && !metadataKeys.isEmpty()) {
            if (!metadataRequestContext.getKeyComponents().isEmpty()) {
                Collection<MetadataKey> innerKeys = MetadataRetrievalManager.getInnerKeys(metadataKeys, metadataRequestContext.getKeyComponents(), metadataRequestContext.getUpdatedNode().getProperties());
                metadataKeys = new ArrayList<MetadataKey>(innerKeys);
            }
            MetadataKeyDisplay displayType = MetadataHelpers.getMetadataKeyDisplay(metadataRequestContext.getUpdatedNode(), metadataRequestContext.getMuleProject());
            retrievedEnumOptionsKeys = MetadataRetrievalManager.convertMetadataKeysToEnumOptions(displayType, metadataKeys);
        } else {
            retrievedEnumOptionsKeys = Collections.emptyList();
        }
        return retrievedEnumOptionsKeys;
    }

    private static List<MetadataKey> retrieveMetadataKeys(MetadataRequestContext metadataRequestContext, String category) {
        IMuleProject muleProject = metadataRequestContext.getMuleProject();
        IMessageFlowNode updatedNode = metadataRequestContext.getUpdatedNode();
        String metadataCacheKey = MetadataHelpers.getMetadataCacheKey(updatedNode);
        ITypesManager typesManager = ((MetadataTypesManager)muleProject.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
        Set metadataKeys = new HashSet();
        if (typesManager != null) {
            metadataKeys = typesManager.getMetadataKeys(metadataCacheKey, category);
        }
        return metadataKeys.stream().collect(Collectors.toList());
    }

    public static List<EnumOption> getEnumOptionsMetadataKeys(IMuleProject muleProject, MuleConfiguration muleConfiguration, IMessageFlowNode originalNode, IMessageFlowNode updatedCurrentNode, String globalRefElementName, boolean postJobIfAbsent, String editorId) {
        List<EnumOption> retrievedEnumOptionsKeys;
        String category = MetadataHelpers.getMessageFlowCategory(updatedCurrentNode);
        List<MetadataKey> metadataKeys = MetadataRetrievalManager.retrieveMetadataKeys(muleProject, muleConfiguration, globalRefElementName, category, postJobIfAbsent, originalNode, updatedCurrentNode, editorId);
        if (metadataKeys != null && !metadataKeys.isEmpty()) {
            MetadataKeyDisplay displayType = MetadataHelpers.getMetadataKeyDisplay(updatedCurrentNode, muleProject);
            retrievedEnumOptionsKeys = MetadataRetrievalManager.convertMetadataKeysToEnumOptions(displayType, metadataKeys);
        } else {
            retrievedEnumOptionsKeys = Collections.emptyList();
        }
        return retrievedEnumOptionsKeys;
    }

    private static List<EnumOption> convertMetadataKeysToEnumOptions(MetadataKeyDisplay displayType, List<MetadataKey> metadataKeys) {
        return metadataKeys.stream().filter(Objects::nonNull).map(metadataKey -> new EnumOption(metadataKey.getId(), MetadataHelpers.getMetadataKeyDisplayName(metadataKey, displayType))).collect(Collectors.toList());
    }

    public static List<EnumOption> getConfiglessEnumOptionsMetadataKeys(IMuleProject muleProject, MuleConfiguration muleConfiguration, IMessageFlowNode originalNode, IMessageFlowNode updatedCurrentNode, String metadataCacheKey, boolean postJobIfAbsent, List<String> keyComponents, String componentPath, String editorId) {
        List<EnumOption> retrievedEnumOptionsKeys;
        String category = MetadataHelpers.getMessageFlowCategory(updatedCurrentNode);
        List<MetadataKey> metadataKeys = MetadataRetrievalManager.retrieveConfiglessMetadataKeys(muleProject, muleConfiguration, metadataCacheKey, category, postJobIfAbsent, originalNode, updatedCurrentNode, componentPath, editorId);
        if (metadataKeys != null && !metadataKeys.isEmpty()) {
            Collection<MetadataKey> innerKeys = MetadataRetrievalManager.getInnerKeys(metadataKeys, keyComponents, updatedCurrentNode.getProperties());
            metadataKeys = new ArrayList<MetadataKey>(innerKeys);
            MetadataKeyDisplay displayType = MetadataHelpers.getMetadataKeyDisplay(updatedCurrentNode, muleProject);
            retrievedEnumOptionsKeys = MetadataRetrievalManager.convertMetadataKeysToEnumOptions(displayType, metadataKeys);
        } else {
            retrievedEnumOptionsKeys = Collections.emptyList();
        }
        return retrievedEnumOptionsKeys;
    }

    public static List<EnumOption> getEnumOptionsMetadataKeys(IMuleProject muleProject, MuleConfiguration muleConfiguration, IMessageFlowNode originalNode, IMessageFlowNode updatedCurrentNode, String globalRefElementName, boolean postJobIfAbsent, List<String> keyComponents, String editorId) {
        List<EnumOption> retrievedEnumOptionsKeys;
        String category = MetadataHelpers.getMessageFlowCategory(updatedCurrentNode);
        List<MetadataKey> metadataKeys = MetadataRetrievalManager.retrieveMetadataKeys(muleProject, muleConfiguration, globalRefElementName, category, postJobIfAbsent, originalNode, updatedCurrentNode, editorId);
        if (metadataKeys != null && !metadataKeys.isEmpty()) {
            Collection<MetadataKey> innerKeys = MetadataRetrievalManager.getInnerKeys(metadataKeys, keyComponents, updatedCurrentNode.getProperties());
            metadataKeys = new ArrayList<MetadataKey>(innerKeys);
            MetadataKeyDisplay displayType = MetadataHelpers.getMetadataKeyDisplay(updatedCurrentNode, muleProject);
            retrievedEnumOptionsKeys = MetadataRetrievalManager.convertMetadataKeysToEnumOptions(displayType, metadataKeys);
        } else {
            retrievedEnumOptionsKeys = Collections.emptyList();
        }
        return retrievedEnumOptionsKeys;
    }

    private static List<MetadataKey> retrieveMetadataKeys(IMuleProject muleProject, MuleConfiguration muleConfiguration, String configRefName, String category, boolean postJobIfAbsent, IMessageFlowNode originalNode, IMessageFlowNode updatedCurrentNode, String editorID) {
        GlobalElement globalElement;
        ITypesManager typesManager = ((MetadataTypesManager)muleProject.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
        Set metadataKeys = new HashSet();
        if (typesManager != null && (metadataKeys = typesManager.getMetadataKeys(configRefName, category)).isEmpty() && postJobIfAbsent && (globalElement = CoreUtils.retrieveGlobalElement((MuleConfiguration)muleConfiguration, (IMuleProject)muleProject, (String)configRefName)) != null && MetadataHelpers.usesMetadataKeys((IMessageFlowNode)globalElement)) {
            MuleConfiguration globalElementMuleConfiguration = MetadataUtils.getMuleConfigurationFor((IMuleProject)muleProject, (String)configRefName);
            try {
                boolean showEditLinkIfError = MetadataRetrievalManager.configurationIsNotExternal(muleProject, globalElementMuleConfiguration);
                GetMetadataKeysExecutor dataSenseOperation = new GetMetadataKeysExecutor(muleProject, globalElementMuleConfiguration, (IMessageFlowNode)globalElement, showEditLinkIfError, configRefName, editorID, category);
                DataSenseProcessorQueue.getInstance().queue(dataSenseOperation);
                metadataKeys = typesManager.getMetadataKeys(configRefName, category);
            }
            catch (Exception e) {
                MuleCorePlugin.logError((String)"Error while preparing tooling application", (Throwable)e);
            }
        }
        return metadataKeys.stream().collect(Collectors.toList());
    }

    private static List<MetadataKey> retrieveConfiglessMetadataKeys(IMuleProject muleProject, MuleConfiguration muleConfiguration, String metadataCacheKey, String category, boolean postJobIfAbsent, IMessageFlowNode originalNode, IMessageFlowNode updatedCurrentNode, String componentPath, String editorId) {
        ITypesManager typesManager = ((MetadataTypesManager)muleProject.getProjectComponent(MetadataTypesManager.class)).getTypesManager();
        Set metadataKeys = new HashSet();
        if (typesManager != null && (metadataKeys = typesManager.getMetadataKeys(metadataCacheKey, category)).isEmpty() && postJobIfAbsent) {
            GetMetadataKeysExecutor dataSenseOperation = new GetMetadataKeysExecutor(muleProject, muleConfiguration, originalNode, updatedCurrentNode, false, metadataCacheKey, componentPath, () -> updatedCurrentNode, x -> updatedCurrentNode.getProperties().toPropertyCollectionMap(), editorId, category);
            DataSenseProcessorQueue.getInstance().queue(dataSenseOperation);
            metadataKeys = typesManager.getMetadataKeys(metadataCacheKey, category);
        }
        return metadataKeys.stream().collect(Collectors.toList());
    }

    private static boolean configurationIsNotExternal(IMuleProject muleProject, MuleConfiguration globalElementMuleConfiguration) {
        return !muleProject.getConfigurationsCache().getExternalConfigurations().contains(globalElementMuleConfiguration);
    }

    private static Collection<MetadataKey> getInnerKeys(Collection<MetadataKey> keys, List<String> keyComponents, IReadOnlyPropertyCollection propertyCollection) {
        if (keyComponents.isEmpty()) {
            return keys;
        }
        if (!keys.isEmpty()) {
            String keyPart = keyComponents.get(0);
            String keyPartValue = PropertiesUtils.getPropertyValue((IPropertyCollectionReadCapability)propertyCollection, (String)keyPart);
            for (MetadataKey metadataKey : keys) {
                if (!metadataKey.getId().equals(keyPartValue)) continue;
                if (keyComponents.size() == 1) {
                    return metadataKey.getChilds();
                }
                return MetadataRetrievalManager.getInnerKeys(metadataKey.getChilds(), keyComponents.subList(1, keyComponents.size()), propertyCollection);
            }
        }
        return Collections.emptyList();
    }
}

