/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class MetadataRequestContext {
    private final IMuleProject muleProject;
    private final MuleConfiguration muleConfiguration;
    private final IMessageFlowNode originalNode;
    private final IMessageFlowNode updatedNode;
    private final AttributesPropertyPage propertyPage;
    private final List<String> keyComponents;
    private final Consumer<List<EnumOption>> enumOptionsConsumer;
    private final String componentPath;
    private final boolean postJobIfAbsent;

    public MetadataRequestContext(MetadataRequestContextBuilder metadataRequestContextBuilder) {
        this.muleProject = Objects.requireNonNull(metadataRequestContextBuilder.muleProject);
        this.muleConfiguration = Objects.requireNonNull(metadataRequestContextBuilder.muleConfiguration);
        this.originalNode = Objects.requireNonNull(metadataRequestContextBuilder.originalNode);
        this.updatedNode = Objects.requireNonNull(metadataRequestContextBuilder.updatedNode);
        this.propertyPage = Objects.requireNonNull(metadataRequestContextBuilder.propertyPage);
        this.keyComponents = Objects.requireNonNull(metadataRequestContextBuilder.keyComponents);
        this.enumOptionsConsumer = Objects.requireNonNull(metadataRequestContextBuilder.enumOptionsConsumer);
        this.componentPath = Objects.requireNonNull(metadataRequestContextBuilder.componentPath);
        this.postJobIfAbsent = metadataRequestContextBuilder.postJobIfAbsent;
    }

    public IMuleProject getMuleProject() {
        return this.muleProject;
    }

    public MuleConfiguration getMuleConfiguration() {
        return this.muleConfiguration;
    }

    public IMessageFlowNode getOriginalNode() {
        return this.originalNode;
    }

    public IMessageFlowNode getUpdatedNode() {
        return this.updatedNode;
    }

    public AttributesPropertyPage getPropertyPage() {
        return this.propertyPage;
    }

    public List<String> getKeyComponents() {
        return this.keyComponents;
    }

    public Consumer<List<EnumOption>> getEnumOptionsConsumer() {
        return this.enumOptionsConsumer;
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public boolean isPostJobIfAbsent() {
        return this.postJobIfAbsent;
    }

    public static MetadataRequestContextBuilder newBuilder() {
        return new MetadataRequestContextBuilder();
    }

    public static class MetadataRequestContextBuilder {
        private IMuleProject muleProject;
        private MuleConfiguration muleConfiguration;
        private IMessageFlowNode originalNode;
        private IMessageFlowNode updatedNode;
        private AttributesPropertyPage propertyPage;
        private List<String> keyComponents;
        private Consumer<List<EnumOption>> enumOptionsConsumer;
        private String componentPath;
        private boolean postJobIfAbsent;

        private MetadataRequestContextBuilder() {
        }

        public MetadataRequestContextBuilder withMuleProject(IMuleProject muleProject) {
            this.muleProject = muleProject;
            return this;
        }

        public MetadataRequestContextBuilder withMuleConfiguration(MuleConfiguration muleConfiguration) {
            this.muleConfiguration = muleConfiguration;
            return this;
        }

        public MetadataRequestContextBuilder withOriginalNode(IMessageFlowNode originalNode) {
            this.originalNode = originalNode;
            return this;
        }

        public MetadataRequestContextBuilder withUpdatedNode(IMessageFlowNode updatedNode) {
            this.updatedNode = updatedNode;
            return this;
        }

        public MetadataRequestContextBuilder withPropertyPage(AttributesPropertyPage propertyPage) {
            this.propertyPage = propertyPage;
            return this;
        }

        public MetadataRequestContextBuilder withKeyComponents(List<String> keyComponents) {
            this.keyComponents = keyComponents;
            return this;
        }

        public MetadataRequestContextBuilder withEnumOptionsConsumer(Consumer<List<EnumOption>> enumOptionsConsumer) {
            this.enumOptionsConsumer = enumOptionsConsumer;
            return this;
        }

        public MetadataRequestContextBuilder withComponentPath(String componentPath) {
            this.componentPath = componentPath;
            return this;
        }

        public MetadataRequestContextBuilder withPoastJobIfAbsent(boolean postJobIfAbsent) {
            this.postJobIfAbsent = postJobIfAbsent;
            return this;
        }

        public MetadataRequestContext build() {
            return new MetadataRequestContext(this);
        }
    }
}

