/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.enricher.MetadataEventEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataTypeRef;
import org.mule.tooling.core.Category;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.requirement.RequirementValidator;
import org.mule.tooling.core.requirement.ValidationResultSet;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.dialog.ISimpleHost;
import org.mule.tooling.messageflow.editor.MessageFlowEditor;
import org.mule.tooling.messageflow.module.MessageFlowNodeComposite;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.PatternDefinition;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.ui.modules.core.metadata.ConnectivityStatus;
import org.mule.tooling.ui.modules.core.metadata.MetadataCacheKeyProvider;
import org.mule.tooling.ui.modules.core.metadata.MetadataKeyDisplay;
import org.mule.tooling.ui.modules.core.metadata.MetadataRetrievalManager;
import org.mule.tooling.ui.modules.core.metadata.MetadataStatus;
import org.mule.tooling.ui.modules.core.metadata.RequiredAttributesGroup;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.EditorHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractCompositeAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeGroupRequirement;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.meta.GlobalRefAttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.MultiWayHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;

public final class MetadataHelpers {
    private static final String DEFAULT_TEST_CONNECTION_LABEL = "Test Connection...";

    private MetadataHelpers() {
    }

    public static boolean isCloudConnector(IMessageFlowNode node) {
        return node instanceof PatternNode && node.getDefinition() instanceof PatternDefinition && ((PatternDefinition)node.getDefinition()).isCloudConnector();
    }

    public static boolean isFilter(IMessageFlowNode node) {
        NodeDefinition definitionFrom = node.getDefinition();
        return definitionFrom != null && Category.FILTERS.getCategoryString().equals(definitionFrom.getCategoryId());
    }

    public static boolean isNodeAllowCustomMetadataDefinition(IMessageFlowNode node) {
        GlobalComponentMeta globalDefinitionMeta;
        IMuleModuleManager moduleManager;
        GlobalDefinition globalDefinition;
        String globalType;
        String globalReferenceAttributeName = MetadataUtils.getGlobalReferenceAttributeName((IMessageFlowNode)node);
        AbstractComponentMeta connectorMeta = MetadataHelpers.getMetaObjectFrom(node);
        GlobalRefAttributeHelper globalRefAttributes = (GlobalRefAttributeHelper)connectorMeta.getAttribute(globalReferenceAttributeName);
        if (globalRefAttributes != null && StringUtils.isNotBlank((String)(globalType = globalRefAttributes.getRequiredType(""))) && (globalDefinition = (moduleManager = MuleCorePlugin.getModuleManager()).getGlobalDefinition(globalType)) != null && (globalDefinitionMeta = (GlobalComponentMeta)MetadataHelpers.getMetaObjectFrom((NodeDefinition)globalDefinition)) != null) {
            return globalDefinitionMeta.supportsUserDefinedMetadata();
        }
        return false;
    }

    public static List<EnumOption> getMetadataTypes(AttributesPropertyPage propertyPage) {
        return MetadataHelpers.getMetadataTypes(propertyPage, true);
    }

    public static List<EnumOption> getCachedMetadataTypes(AbstractFieldEditor editor) {
        return MetadataHelpers.getMetadataTypes(editor.getParentPage(), false);
    }

    private static List<EnumOption> getMetadataTypes(AttributesPropertyPage propertyPage, boolean postJobIfAbsent) {
        List<EnumOption> cachedMetadataTypes = new ArrayList<EnumOption>();
        IMessageFlowNode currentNode = propertyPage.getMessageFlowNode();
        if (currentNode != null) {
            List<MessageFlowNodeComposite> pages = EditorHelper.getAllCurrentEditorPages(propertyPage);
            IMessageFlowNode updatedCurrentNode = (IMessageFlowNode)MessageFlowUtils.generateNodeToTestSupplier((IMessageFlowNode)currentNode).get();
            Function updatedPropertiesProvider = MessageFlowUtils.updatedPropertiesProvider(pages);
            updatedCurrentNode.setProperties(((PropertyCollectionMap)updatedPropertiesProvider.apply(updatedCurrentNode)).asPropertyCollection());
            MessageFlowEditor flowEditorFromActivePage = MessageFlowUtils.getFlowEditorFromActivePage();
            if (flowEditorFromActivePage != null) {
                try {
                    AttributesPropertyPage attributesPropertyPage = propertyPage;
                    String globalRefElementName = attributesPropertyPage.getGlobalElementName(updatedCurrentNode);
                    if (StringUtils.isNotBlank((String)globalRefElementName)) {
                        IMuleProject muleProject = flowEditorFromActivePage.getMuleProject();
                        MuleConfiguration muleConfiguration = flowEditorFromActivePage.getMuleConfiguration();
                        cachedMetadataTypes = MetadataRetrievalManager.getEnumOptionsMetadataKeys(muleProject, muleConfiguration, currentNode, updatedCurrentNode, globalRefElementName, postJobIfAbsent, null);
                    }
                }
                catch (Exception e) {
                    MuleCorePlugin.logError((String)"Error getting DataSense types...", (Throwable)e);
                }
            }
        }
        return cachedMetadataTypes;
    }

    public static String getNameAttributeName(IMessageFlowNode node) {
        AbstractComponentMeta metaObjectFrom;
        String fieldName = null;
        if (node != null && (metaObjectFrom = MetadataHelpers.getMetaObjectFrom(node)) != null) {
            List<AttributeHelper> allAttributes = metaObjectFrom.getAllAttributes();
            Iterator it = allAttributes.iterator();
            block0: while (it.hasNext() && fieldName == null) {
                AttributeHelper attHelper = (AttributeHelper)it.next();
                if (attHelper instanceof AttributeReader.NameHelper) {
                    fieldName = attHelper.getId();
                    continue;
                }
                if (!(attHelper instanceof AbstractCompositeAttributeHelper)) continue;
                for (AttributeHelper childAttrHelper : ((AbstractCompositeAttributeHelper)attHelper).getChildren()) {
                    if (!(childAttrHelper instanceof AttributeReader.NameHelper)) continue;
                    fieldName = childAttrHelper.getId();
                    continue block0;
                }
            }
        }
        return fieldName;
    }

    private static List<RequiredAttributesGroup> getRequiredAttributesGroupsFrom(List<AttributeGroupRequirement> metaRequirements) {
        ArrayList<RequiredAttributesGroup> reqs = new ArrayList<RequiredAttributesGroup>();
        for (AttributeGroupRequirement metaRequirement : metaRequirements) {
            if (!metaRequirement.requiredForDataSense()) continue;
            List<LinkedHashSet<String>> requiredAttrs = metaRequirement.getRequiredAttrs();
            for (LinkedHashSet<String> linkedHashSet : requiredAttrs) {
                reqs.add(new RequiredAttributesGroup(linkedHashSet));
            }
        }
        return reqs;
    }

    public static List<RequiredAttributesGroup> getRequiredForDataSenseAttributeNames(NodeDefinition definition) {
        List<RequiredAttributesGroup> requiredAttributes = new ArrayList<RequiredAttributesGroup>();
        AbstractComponentMeta abstractComponentMeta = MetadataHelpers.getMetaObjectFrom(definition);
        if (abstractComponentMeta != null) {
            List<AttributeGroupRequirement> metaRequirements = abstractComponentMeta.getAttributeGroupRequirements();
            if (metaRequirements != null && !metaRequirements.isEmpty()) {
                requiredAttributes = MetadataHelpers.getRequiredAttributesGroupsFrom(metaRequirements);
            }
            if (requiredAttributes.isEmpty()) {
                List<AttributeHelper> allAttributes = abstractComponentMeta.getAllAttributes();
                RequiredAttributesGroup requiredAttributesGroup = new RequiredAttributesGroup();
                for (AttributeHelper attHelper : allAttributes) {
                    if (!attHelper.isRequiredForDataSense()) continue;
                    requiredAttributesGroup.addAttribute(attHelper.getId());
                }
                requiredAttributes.add(requiredAttributesGroup);
            }
        }
        return requiredAttributes;
    }

    public static boolean areDataSenseRequirementsFulfilled(NodeDefinition nodeDefinition, PropertyCollectionMap updatedProperties, IMuleProject muleProject) {
        boolean requiredForDatasenseAttributesFulfilled = false;
        boolean jarRequirements = false;
        boolean bl = requiredForDatasenseAttributesFulfilled = MetadataHelpers.collectionHasAllAttributesRequiredForDatasense(nodeDefinition, updatedProperties.asPropertyCollection()) && MetadataHelpers.childAttributesRequiredForDatasenseConfigured(nodeDefinition, updatedProperties, muleProject);
        if (requiredForDatasenseAttributesFulfilled) {
            jarRequirements = MetadataHelpers.areAllRequirementsFullfilled(nodeDefinition, updatedProperties, muleProject);
        }
        return requiredForDatasenseAttributesFulfilled && jarRequirements;
    }

    private static boolean childAttributesRequiredForDatasenseConfigured(NodeDefinition definition, PropertyCollectionMap updatedProperties, IMuleProject muleProject) {
        boolean configured = true;
        Map propertyCollections = updatedProperties.getPropertyCollections();
        for (Map.Entry property : propertyCollections.entrySet()) {
            PropertyCollection propertyCollectionMap = ((PropertyCollectionMap)property.getValue()).asPropertyCollection();
            String nodeDefinitionId = PropertiesUtils.getNodeDefinitionId((String)((String)property.getKey()));
            NestedDefinition nestedDefinition = muleProject.getModuleManager().getNestedDefinition(nodeDefinitionId);
            if (nestedDefinition == null) continue;
            if (!MetadataHelpers.collectionHasAllAttributesRequiredForDatasense((NodeDefinition)nestedDefinition, propertyCollectionMap)) {
                configured = false;
                break;
            }
            if (nestedDefinition.getId() != null && nestedDefinition.getId().equals("http://www.mulesoft.org/schema/mule/a2a/connection")) {
                return false;
            }
            return MetadataHelpers.areAllRequirementsFullfilled((NodeDefinition)nestedDefinition, updatedProperties, muleProject);
        }
        return configured;
    }

    public static boolean collectionHasAllAttributesRequiredForDatasense(NodeDefinition definition, PropertyCollection propertyCollectionMap) {
        boolean configured = true;
        List<RequiredAttributesGroup> requiredForDataSenseGroups = MetadataHelpers.getRequiredForDataSenseAttributeNames(definition);
        Optional<Set<MultiWayHelper>> multiwayHelpers = Optional.ofNullable(MetadataHelpers.getMetaObjectFrom(definition)).map(AbstractComponentMeta::getMultiwayHelpers);
        for (RequiredAttributesGroup requiredAttributeGroup : requiredForDataSenseGroups) {
            List<String> arguments = requiredAttributeGroup.getArguments();
            if (MetadataHelpers.allPropertiesInGroupAreConfigured(propertyCollectionMap, arguments, multiwayHelpers)) continue;
            configured = false;
            break;
        }
        return configured;
    }

    private static boolean allPropertiesInGroupAreConfigured(PropertyCollection collection, List<String> arguments, Optional<Set<MultiWayHelper>> multiwayHelpers) {
        boolean filledFields = true;
        for (String argument : arguments) {
            Property property = collection.getProperty(argument);
            if (property != null) {
                String fieldValue = property.getValue();
                if (!StringUtils.isBlank((String)fieldValue)) continue;
                filledFields = false;
                break;
            }
            if (multiwayHelpers.isPresent()) {
                boolean propertyIsMultiway = false;
                PropertyCollectionMap properties = collection.toPropertyCollectionMap();
                for (MultiWayHelper multiWayHelper : multiwayHelpers.get()) {
                    boolean isAnyChildModeConfigured;
                    String helperId = multiWayHelper.getId();
                    if (!argument.equals(helperId)) continue;
                    propertyIsMultiway = true;
                    if (!MultiWayHelper.isMultiwayInChildMode(properties, helperId) || (isAnyChildModeConfigured = MetadataHelpers.isAnyChildModeConfigured(properties, multiWayHelper))) continue;
                    filledFields = false;
                    break;
                }
                if (propertyIsMultiway) break;
                filledFields = PropertiesUtils.isChildElement((String)argument, (PropertyCollectionMap)properties);
                break;
            }
            filledFields = false;
            break;
        }
        return filledFields;
    }

    private static boolean isAnyChildModeConfigured(PropertyCollectionMap properties, MultiWayHelper multiWayHelper) {
        boolean isAnyChildModeConfigured = false;
        Collection<String> xmlNames = multiWayHelper.getXmlNames();
        for (String xmlName : xmlNames) {
            if (!PropertiesUtils.isChildElement((String)xmlName, (PropertyCollectionMap)properties)) continue;
            isAnyChildModeConfigured |= true;
            break;
        }
        return isAnyChildModeConfigured;
    }

    private static boolean areAllRequirementsFullfilled(NodeDefinition definition, PropertyCollectionMap updatedProperties, IMuleProject muleProject) {
        Collection<Requirement> requirements = MetadataHelpers.getRequirementsFor(definition, updatedProperties, muleProject.getModuleManager());
        ValidationResultSet jarValidationResultSet = RequirementValidator.validate((IMuleProject)muleProject, requirements);
        boolean jarRequirements = jarValidationResultSet.allPassed();
        return jarRequirements;
    }

    public static Collection<Requirement> getRequirementsFor(NodeDefinition definition, PropertyCollectionMap updatedProperties, IMuleModuleManager muleModuleManager) {
        Collection<Requirement> childRequirements = MetadataHelpers.getChildRequirements(updatedProperties, muleModuleManager);
        childRequirements.addAll(definition.getRequirements());
        return childRequirements;
    }

    private static Collection<Requirement> getChildRequirements(PropertyCollectionMap updatedProperties, IMuleModuleManager muleModuleManager) {
        ArrayList<Requirement> childRequirements = new ArrayList<Requirement>();
        updatedProperties.getPropertyCollections().forEach((property, value) -> {
            String nodeDefinitionId = PropertiesUtils.getNodeDefinitionId((String)property);
            NestedDefinition nestedDefinition = muleModuleManager.getNestedDefinition(nodeDefinitionId);
            if (nestedDefinition != null) {
                childRequirements.addAll(nestedDefinition.getRequirements());
            }
        });
        return childRequirements;
    }

    public static ConnectivityStatus getConnectivityTestingStatus(IMessageFlowNode node) {
        String connectivityTestingStatus;
        ConnectivityStatus returnType = null;
        AbstractComponentMeta metaObject = MetadataHelpers.getMetaObjectFrom(node);
        if (metaObject != null && !StringUtils.isEmpty((String)(connectivityTestingStatus = metaObject.getConnectivityTesting()))) {
            returnType = ConnectivityStatus.parseStatus(connectivityTestingStatus);
        }
        return returnType;
    }

    public static MetadataKeyDisplay getMetadataKeyDisplay(IMessageFlowNode node, IMuleProject project) {
        MetadataKeyDisplay returnType = null;
        String configRef = MetadataUtils.getGlobalReference((IMessageFlowNode)node);
        List muleConfigs = project.getConfigurationsCache().getConfigurations();
        for (MuleConfiguration muleConfiguration : muleConfigs) {
            GlobalElement globalElement = CoreUtils.retrieveGlobalElement((MuleConfiguration)muleConfiguration, (String)configRef);
            if (globalElement == null) continue;
            AbstractComponentMeta metaObject = MetadataHelpers.getMetaObjectFrom((IMessageFlowNode)globalElement);
            if (metaObject == null) break;
            String stringMetadataKeyDisplay = metaObject.getMetadataKeyDisplay();
            returnType = MetadataKeyDisplay.parseMetadataKeyDisplay(stringMetadataKeyDisplay);
            break;
        }
        return returnType;
    }

    public static String getMetadataKeyDisplayName(MetadataKey metadataKey, MetadataKeyDisplay displayType) {
        if (MetadataKeyDisplay.ID.equals((Object)displayType)) {
            return metadataKey.getId();
        }
        if (MetadataKeyDisplay.DISPLAY_NAME.equals((Object)displayType)) {
            return metadataKey.getDisplayName();
        }
        if (Objects.equals(metadataKey.getDisplayName(), metadataKey.getId())) {
            return metadataKey.getDisplayName();
        }
        return metadataKey.getDisplayName() + " (" + metadataKey.getId() + ")";
    }

    public static MetadataStatus getMetadataStatus(IMessageFlowNode node) {
        return MetadataHelpers.getMetadataStatus(null, node);
    }

    public static boolean usesMetadataKeys(IMessageFlowNode node) {
        boolean usesMetadataKeys = true;
        AbstractComponentMeta metaObject = MetadataHelpers.getMetaObjectFrom(node);
        if (metaObject != null) {
            usesMetadataKeys = metaObject.isUsesMetadataTypes();
        }
        return usesMetadataKeys;
    }

    public static MetadataStatus getMetadataStatus(PropertyCollectionMap newValuesProperties, IMessageFlowNode node) {
        String metadataTestingStatus;
        MetadataStatus metadataStatus = null;
        AbstractComponentMeta metaObject = MetadataHelpers.getMetaObjectFrom(node);
        if (metaObject != null && !StringUtils.isEmpty((String)(metadataTestingStatus = metaObject.getMetadataStatus()))) {
            metadataStatus = MetadataStatus.parseStatus(metadataTestingStatus);
        }
        return metadataStatus;
    }

    public static boolean usesMetadata(IMessageFlowNode node) {
        MetadataStatus metadataStatus = MetadataHelpers.getMetadataStatus(node);
        return metadataStatus != null && metadataStatus != MetadataStatus.OFF;
    }

    public static boolean configUsesMetadata(MuleConfiguration currentMuleConfig, IMuleProject project, String configRefName) {
        boolean retVal = false;
        GlobalElement globalElement = CoreUtils.retrieveGlobalElement((MuleConfiguration)currentMuleConfig, (String)configRefName);
        retVal = globalElement != null ? MetadataHelpers.usesMetadata((IMessageFlowNode)globalElement) : MetadataHelpers.configUsesMetadata(project, configRefName);
        return retVal;
    }

    public static boolean configUsesMetadata(IMuleProject project, String configRefName) {
        boolean retVal = false;
        List muleConfigs = project.getConfigurationsCache().getConfigurations();
        for (MuleConfiguration muleConfiguration : muleConfigs) {
            GlobalElement globalElement = CoreUtils.retrieveGlobalElement((MuleConfiguration)muleConfiguration, (String)configRefName);
            if (globalElement == null) continue;
            retVal = MetadataHelpers.usesMetadata((IMessageFlowNode)globalElement);
            break;
        }
        return retVal;
    }

    public static AbstractComponentMeta getMetaObjectFrom(IMessageFlowNode node) {
        AbstractComponentMeta meta = null;
        if (node != null) {
            NodeDefinition definition = node.getDefinition();
            meta = MetadataHelpers.getMetaObjectFrom(definition);
        }
        return meta;
    }

    public static AbstractComponentMeta getMetaObjectFrom(NodeDefinition nodeDef) {
        AbstractComponentMeta metaFromNodeDef;
        AbstractComponentMeta metaObject = null;
        if (nodeDef != null && (metaFromNodeDef = (AbstractComponentMeta)nodeDef.getService(AbstractComponentMeta.class)) != null) {
            metaObject = metaFromNodeDef;
        }
        return metaObject;
    }

    public static boolean isTesteable(MessageFlowNode messageFlowNode) {
        ConnectivityStatus connectivityTestingStatus = MetadataHelpers.getConnectivityTestingStatus((IMessageFlowNode)messageFlowNode);
        return connectivityTestingStatus == ConnectivityStatus.ON;
    }

    public static String getTestButtonLabel(MessageFlowNode messageFlowNode) {
        String connectivityTestingLabel;
        String label = DEFAULT_TEST_CONNECTION_LABEL;
        AbstractComponentMeta metaObject = MetadataHelpers.getMetaObjectFrom((IMessageFlowNode)messageFlowNode);
        if (metaObject != null && !StringUtils.isBlank((String)(connectivityTestingLabel = metaObject.getConnectivityTestingLabel()))) {
            label = connectivityTestingLabel;
        }
        return label;
    }

    public static List<String> getOperationCategories(IMessageFlowNode node) {
        AbstractComponentMeta service;
        AbstractComponentMeta metaObject = MetadataHelpers.getMetaObjectFrom(node);
        if (metaObject != null && (service = MetadataHelpers.getMetaObjectFrom(node)) != null) {
            return service.getCategoryNames();
        }
        return Collections.emptyList();
    }

    public static boolean connectorHasMetadata(IMessageFlowNode messageFlowNode) {
        MetadataStatus metadataStatus = MetadataHelpers.getMetadataStatus(messageFlowNode);
        return metadataStatus == MetadataStatus.DYNAMIC || metadataStatus == MetadataStatus.STATIC;
    }

    public static boolean belongsToPropertyPage(IMuleProject muleProject, IMessageFlowNode messageFlowNode, AttributesPropertyPage attributesPropertyPage) {
        IMessageFlowNode currentNode = attributesPropertyPage.getMessageFlowNode();
        MessageFlowNode updatedNode = MessageFlowUtils.generateNodeToTest((IMessageFlowNode)currentNode, (ISimpleHost)attributesPropertyPage.getHost());
        String globalReferenceName = MetadataUtils.getGlobalReference((IMessageFlowNode)updatedNode);
        String nameProperty = CoreUtils.getNameProperty((IMessageFlowNode)messageFlowNode);
        return attributesPropertyPage.getMuleProject().equals(muleProject) && (MessageFlowUtils.checkNodeEquality((IMessageFlowNode)currentNode, (IMessageFlowNode)messageFlowNode) || StringUtils.isNotBlank((String)nameProperty) && nameProperty.equals(globalReferenceName));
    }

    public static ComponentId defineComponentIdProperty(IMessageFlowNode node, PropertyCollectionMap properties, ComponentId componentId) {
        if (componentId.isUndefined() && ComponentId.acceptsAutogeneratedDocIdValue((IMessageFlowNode)node)) {
            componentId = ComponentId.create();
            properties.addProperty("doc:id", componentId.toString());
            PropertyCollection newProperties = PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)node.getProperties());
            newProperties.setProperty("doc:id", componentId.toString());
            node.setProperties(newProperties);
        }
        return componentId;
    }

    public static MetadataEventEnricher mergeMetadataContents(MetadataEventEnricher previous, MetadataEventEnricher current) {
        MetadataEventEnricher enricher = new MetadataEventEnricher();
        enricher.setPayload(Optional.ofNullable(current.getPayload()).orElse(previous.getPayload()));
        enricher.setAttributes(Optional.ofNullable(current.getAttributes()).orElse(previous.getAttributes()));
        for (Map.Entry<String, MetadataTypeRef> entry : MetadataHelpers.mergeMaps(previous.getVariables(), current.getVariables()).entrySet()) {
            enricher.addVariable(entry.getKey(), entry.getValue());
        }
        return enricher;
    }

    private static Map<String, MetadataTypeRef> mergeMaps(Map<String, MetadataTypeRef> map1, Map<String, MetadataTypeRef> map2) {
        HashMap variables = Maps.newHashMap(map1);
        variables.putAll(map2);
        return variables;
    }

    public static String getMessageFlowCategory(IMessageFlowNode messageFlowNode) {
        List<String> categories = MetadataHelpers.getOperationCategories(messageFlowNode);
        String category = "#Default Category#";
        if (!categories.isEmpty()) {
            category = categories.get(0);
        }
        return category;
    }

    public static String getMetadataCacheKey(IMessageFlowNode messageFlowNode) {
        return ((MetadataCacheKeyProvider)messageFlowNode.getDefinition().getService(MetadataCacheKeyProvider.class)).getKey(messageFlowNode);
    }
}

