/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.mule.tooling.client.ToolingComponentPath;
import org.mule.tooling.client.api.IComponentPath;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.IMetadataPropagationCache;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.ToolingJobsManager;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.datasense.DataSenseJob;
import org.mule.tooling.metadata.datasense.DataSenseRequest;
import org.mule.tooling.metadata.datasense.DataSenseResponse;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.modules.core.ModulesActivator;
import org.mule.tooling.ui.modules.core.api.metadata.IDataSenseResolver;
import org.mule.tooling.ui.modules.core.metadata.propagation.MetadataPropagationCache;

public class DataSenseResolver
implements IDataSenseResolver {
    public static final String DATASENSE_JOB_FAMILY = "DataSenseProcessor";
    private static final boolean PROPAGATION_CACHE_DISABLED = Boolean.getBoolean("tooling.propagation.cache.disabled");
    private final ExecutorService dataSenseExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Data Sense Service").setDaemon(true).build());

    public static DataSenseResolver getInstance() {
        return MetadataPropagationResolverInstanceHolder.INSTANCE;
    }

    private DataSenseResolver() {
    }

    @Override
    public CompletableFuture<DataSenseResponse> resolveDataSense(DataSenseRequest request) {
        ModulesActivator.debugTracer().trace(ModulesActivator.DISPATCH_METADATA_JOBS_ID, "Dispatching job for: " + request.getMulePath().toPath());
        ModulesActivator.debugTracer().traceDumpStack(ModulesActivator.DISPATCH_METADATA_JOBS_TRACE_ID);
        return CompletableFuture.supplyAsync(() -> this.dispatchDataSenseJob(request), this.dataSenseExecutor);
    }

    private DataSenseResponse dispatchDataSenseJob(DataSenseRequest request) {
        Optional<PropagationInfo> maybePropagationInfo;
        IMuleProject project = request.getProject();
        MuleConfiguration muleConfiguration = request.getMuleConfiguration();
        if (this.isStaleConfig(muleConfiguration, project)) {
            return DataSenseResponse.DEFAULT;
        }
        MulePath mulePath = request.getMulePath();
        EditingScope scope = request.getScope();
        DataSenseRequest.DataSenseRequestType dataSenseRequestType = request.getDataSenseRequestType();
        ToolingComponentPath componentPath = ToolingComponentPath.from((String)mulePath.toPath());
        if (request.isForceRequest()) {
            if (!DataSenseRequest.DataSenseRequestType.COMPONENT.equals((Object)dataSenseRequestType)) {
                ((IMetadataPropagationCache)MuleCorePlugin.getStudioContext().get(IMetadataPropagationCache.class)).evictProjectPropagation(project);
            }
        } else if (DataSenseRequest.DataSenseRequestType.PROPAGATION.equals((Object)dataSenseRequestType) && (maybePropagationInfo = this.fetchFromCacheIfPossible(project, componentPath, scope)).isPresent()) {
            return new DataSenseResponse(maybePropagationInfo.get());
        }
        DataSenseJob dataSenseJob = new DataSenseJob(request);
        try {
            dataSenseJob.setJobGroup(ToolingJobsManager.getToolingJobGroup());
            dataSenseJob.setPriority(20);
            dataSenseJob.schedule();
            dataSenseJob.join();
        }
        catch (InterruptedException e) {
            MuleCorePlugin.logError((String)"Error while resolving data sense", (Throwable)e);
        }
        return dataSenseJob.getDataSenseResponse();
    }

    private boolean isStaleConfig(MuleConfiguration muleConfiguration, IMuleProject project) {
        return !project.getConfigurationsCache().getConfigurations().contains(muleConfiguration);
    }

    private Optional<PropagationInfo> fetchFromCacheIfPossible(IMuleProject project, ToolingComponentPath componentPath, EditingScope scope) {
        Optional<PropagationInfo> maybePropagationInfo = Optional.empty();
        Optional cachedResult = MetadataPropagationCache.getInstance().get(project, (IComponentPath)componentPath, scope);
        if (cachedResult.isPresent() && !PROPAGATION_CACHE_DISABLED) {
            ModulesActivator.debugTracer().trace(ModulesActivator.DISPATCH_METADATA_JOBS_ID, "Fetching propagation from cache: " + componentPath.toPath());
            maybePropagationInfo = Optional.of((PropagationInfo)cachedResult.get());
        }
        return maybePropagationInfo;
    }

    private static class MetadataPropagationResolverInstanceHolder {
        private static final DataSenseResolver INSTANCE = new DataSenseResolver();

        private MetadataPropagationResolverInstanceHolder() {
        }
    }
}

