/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.metadata;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.tooling.client.api.ComponentDataSenseResult;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.datasense.DataSenseRequest;
import org.mule.tooling.metadata.datasense.DataSenseResponse;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.modules.core.api.metadata.IDataSenseResolver;
import org.mule.tooling.ui.modules.core.metadata.IComponentDataSenseInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.IPropagationInfoProvider;
import org.mule.tooling.ui.modules.core.metadata.events.MetadataPropagationEvent;
import org.mule.tooling.ui.modules.core.metadata.events.MetadataPropagationStartedEvent;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class DataSenseInfoProvider
implements IPropagationInfoProvider,
IComponentDataSenseInfoProvider {
    private EventBus eventBus;
    private IMuleProject project;
    private MuleConfiguration muleConfiguration;
    private MessageFlowEntity messageFlowEntity;
    private DataSenseResponse dataSenseResponse = new DataSenseResponse(WEAVE_UNRESOLVED_METADATA);
    private CompletableFuture<DataSenseResponse> asyncDataSense;

    public DataSenseInfoProvider(EventBus eventBus, IMuleProject project, MuleConfiguration muleConfiguration, MessageFlowEntity messageFlowEntity) {
        this.eventBus = eventBus;
        this.project = project;
        this.muleConfiguration = muleConfiguration;
        this.messageFlowEntity = messageFlowEntity;
        this.reload(DataSenseRequest.DataSenseRequestType.BOTH, null, false, false);
    }

    @Override
    public PropagationInfo getPropagationInfo() {
        return this.dataSenseResponse.getPropagationInfo();
    }

    @Override
    public ComponentDataSenseResult getComponentDataSenseResult() {
        return this.dataSenseResponse.getComponentDataSenseResult();
    }

    @Override
    public void reloadPropagation() {
        this.reload(DataSenseRequest.DataSenseRequestType.PROPAGATION, null, false, false);
    }

    @Override
    public void reloadComponentDataSense() {
        this.reload(DataSenseRequest.DataSenseRequestType.COMPONENT, null, false, false);
    }

    @Override
    public boolean isComponentDataSenseAvailable() {
        return this.asyncDataSense.isDone();
    }

    @Override
    public void thenAccept(Consumer<ComponentDataSenseResult> result) {
        this.asyncDataSense.thenAccept(dsr -> result.accept(dsr.getComponentDataSenseResult()));
    }

    public void reload(DataSenseRequest.DataSenseRequestType dataSenseRequestType, PropertyCollection newPropertyCollection, boolean forceRefresh, boolean evictMetadata) {
        this.eventBus.fireEvent((IEvent)new MetadataPropagationStartedEvent(this.messageFlowEntity));
        this.asyncDataSense = DataSenseInfoProvider.getDataSense(this.project, this.muleConfiguration, this.messageFlowEntity, dataSenseRequestType, newPropertyCollection, forceRefresh, evictMetadata);
        this.asyncDataSense.thenAccept(dsr -> {
            PropagationInfo propagationInfo = this.isPropagationRequired(dataSenseRequestType) ? dsr.getPropagationInfo() : this.dataSenseResponse.getPropagationInfo();
            ComponentDataSenseResult componentDataSenseResult = this.isComponentDataSenseRequired(dataSenseRequestType) ? dsr.getComponentDataSenseResult() : this.dataSenseResponse.getComponentDataSenseResult();
            this.dataSenseResponse = new DataSenseResponse(propagationInfo, componentDataSenseResult);
            this.eventBus.fireEvent((IEvent)new MetadataPropagationEvent(this.dataSenseResponse.getPropagationInfo()));
        });
    }

    private static CompletableFuture<DataSenseResponse> getDataSense(IMuleProject project, MuleConfiguration config, MessageFlowEntity entity, DataSenseRequest.DataSenseRequestType dataSenseRequestType, PropertyCollection newPropertyCollection, boolean forceRefresh, boolean evictMetadata) {
        MulePath mulePath = config.getPathFor((IMessageFlowEntity)entity);
        DataSenseRequest request = new DataSenseRequest(project, EditingScope.getCurrent(), config, mulePath, dataSenseRequestType, newPropertyCollection, forceRefresh, evictMetadata);
        return ((IDataSenseResolver)MuleCorePlugin.getStudioContext().get(IDataSenseResolver.class)).resolveDataSense(request);
    }

    private boolean isPropagationRequired(DataSenseRequest.DataSenseRequestType dataSenseRequestType) {
        return DataSenseRequest.DataSenseRequestType.BOTH == dataSenseRequestType || DataSenseRequest.DataSenseRequestType.PROPAGATION == dataSenseRequestType;
    }

    private boolean isComponentDataSenseRequired(DataSenseRequest.DataSenseRequestType dataSenseRequestType) {
        return DataSenseRequest.DataSenseRequestType.BOTH == dataSenseRequestType || DataSenseRequest.DataSenseRequestType.COMPONENT == dataSenseRequestType;
    }

    public final Optional<MulePath> getEntityMulePath() {
        return Optional.ofNullable(this.muleConfiguration.getPathFor((IMessageFlowEntity)this.messageFlowEntity));
    }
}

