/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.internal.enablement;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.tooling.ui.modules.core.internal.enablement.ParserException;
import org.mule.tooling.ui.modules.core.internal.enablement.TokenType;

public class Tokenizer {
    private LinkedList<TokenInfo> tokenInfos = new LinkedList();
    private LinkedList<Token> tokens = new LinkedList();

    public void add(String regex, TokenType token) {
        this.tokenInfos.add(new TokenInfo(Pattern.compile("^(" + regex + ")"), token));
    }

    public void tokenize(String str) {
        String s = str.trim();
        this.tokens.clear();
        while (!s.equals("")) {
            boolean match = false;
            for (TokenInfo info : this.tokenInfos) {
                Matcher m = info.regex.matcher(s);
                if (!m.find()) continue;
                match = true;
                String tok = m.group().trim();
                s = m.replaceFirst("").trim();
                this.tokens.add(new Token(info.token, tok));
                break;
            }
            if (match) continue;
            throw new ParserException("Unexpected character in input: " + s);
        }
    }

    public LinkedList<Token> getTokens() {
        return this.tokens;
    }

    public class Token {
        public final TokenType token;
        public final String sequence;

        public Token(TokenType token, String sequence) {
            this.token = token;
            this.sequence = sequence;
        }
    }

    private class TokenInfo {
        public final Pattern regex;
        public final TokenType token;

        public TokenInfo(Pattern regex, TokenType token) {
            this.regex = regex;
            this.token = token;
        }
    }
}

