/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.internal.enablement;

import java.util.Iterator;
import org.mule.tooling.ui.modules.core.internal.enablement.CompositeEnablementHandler;
import org.mule.tooling.ui.modules.core.internal.enablement.HasAttribute;
import org.mule.tooling.ui.modules.core.internal.enablement.HasChild;
import org.mule.tooling.ui.modules.core.internal.enablement.IsExpression;
import org.mule.tooling.ui.modules.core.internal.enablement.NegateExpression;
import org.mule.tooling.ui.modules.core.internal.enablement.TokenType;
import org.mule.tooling.ui.modules.core.internal.enablement.Tokenizer;
import org.mule.tooling.ui.modules.core.widgets.editors.IEnablementHandler;

public class EnablementParser {
    private String HAS_ATTRIBUTE = "hasAttr";
    private String IS_EXPRESSION = "isExp";
    private String HAS_CHILD = "hasChild";
    private Tokenizer tokenizer = new Tokenizer();

    public static EnablementParser newIsntance() {
        return new EnablementParser();
    }

    private EnablementParser() {
        this.tokenizer.add(String.format("%s|%s|%s", this.HAS_ATTRIBUTE, this.HAS_CHILD, this.IS_EXPRESSION), TokenType.FUNCTION);
        this.tokenizer.add("\\!", TokenType.NEGATION);
        this.tokenizer.add("\\(", TokenType.PARAMETER_OPEN);
        this.tokenizer.add("\\)", TokenType.PARAMETER_CLOSE);
        this.tokenizer.add("\\&&", TokenType.AND);
        this.tokenizer.add("\\|\\|", TokenType.OR);
        this.tokenizer.add("\\[", TokenType.GROUP_OPEN);
        this.tokenizer.add("\\]", TokenType.GROUP_CLOSE);
        this.tokenizer.add("[a-zA-Z][a-zA-Z0-9_\\-:/\\.]*", TokenType.PARAMETER_NAME);
    }

    public IEnablementHandler getCondition(String expression) {
        this.tokenizer.tokenize(expression);
        Iterator<Tokenizer.Token> iterator = this.tokenizer.getTokens().iterator();
        return this.getGroupCondition(null, iterator);
    }

    private IEnablementHandler getGroupCondition(IEnablementHandler leftCondition, Iterator<Tokenizer.Token> iterator) {
        String currentParameterName = "";
        boolean isAnd = false;
        boolean negate = false;
        boolean isHasAttribute = false;
        boolean isExpression = false;
        IEnablementHandler root = null;
        CompositeEnablementHandler compositeCondition = null;
        block11: do {
            Tokenizer.Token current = iterator.next();
            switch (current.token) {
                case AND: {
                    isAnd = true;
                    break;
                }
                case FUNCTION: {
                    isHasAttribute = this.HAS_ATTRIBUTE.equals(current.sequence);
                    if (isHasAttribute) continue block11;
                    isExpression = this.IS_EXPRESSION.equals(current.sequence);
                    break;
                }
                case GROUP_CLOSE: {
                    throw new RuntimeException("Not yet implemented");
                }
                case GROUP_OPEN: {
                    throw new RuntimeException("Not yet implemented");
                }
                case NEGATION: {
                    negate = true;
                    break;
                }
                case OR: {
                    isAnd = false;
                    break;
                }
                case PARAMETER_CLOSE: {
                    IEnablementHandler currentCondition = this.buildCurrentCondition(currentParameterName, isHasAttribute, isExpression);
                    if (negate) {
                        currentCondition = new NegateExpression(currentCondition);
                    }
                    if (iterator.hasNext() || leftCondition != null) {
                        if (leftCondition == null) {
                            leftCondition = currentCondition;
                            isHasAttribute = false;
                            isExpression = false;
                            negate = false;
                            isAnd = false;
                            break;
                        }
                        compositeCondition = this.buildCompositeCondition(leftCondition, iterator, isAnd, currentCondition);
                        leftCondition = compositeCondition;
                        root = compositeCondition;
                    }
                    if (root == null) {
                        root = currentCondition;
                    }
                    isHasAttribute = false;
                    isExpression = false;
                    negate = false;
                    isAnd = false;
                    break;
                }
                case PARAMETER_NAME: {
                    currentParameterName = current.sequence;
                    break;
                }
                case PARAMETER_OPEN: {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown token");
                }
            }
        } while (iterator.hasNext());
        return root;
    }

    protected CompositeEnablementHandler buildCompositeCondition(IEnablementHandler leftCondition, Iterator<Tokenizer.Token> iterator, boolean isAnd, IEnablementHandler currentCondition) {
        CompositeEnablementHandler compositeCondition;
        if (!isAnd && iterator.hasNext()) {
            IEnablementHandler chain = this.getGroupCondition(null, iterator);
            CompositeEnablementHandler auxComposite = new CompositeEnablementHandler(chain, currentCondition, isAnd);
            compositeCondition = new CompositeEnablementHandler(auxComposite, leftCondition, isAnd);
        } else {
            compositeCondition = new CompositeEnablementHandler(currentCondition, leftCondition, isAnd);
        }
        return compositeCondition;
    }

    protected IEnablementHandler buildCurrentCondition(String currentParameterName, boolean isHasAttribute, boolean isExpression) {
        IEnablementHandler currentCondition = null;
        currentCondition = isHasAttribute ? new HasAttribute(currentParameterName) : (isExpression ? new IsExpression(currentParameterName) : new HasChild(currentParameterName));
        return currentCondition;
    }
}

