/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.exceptionstrategy;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.editors.AbstractFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.IOptionsCalculator;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class DefaultErrorHandlerCalculator
implements IOptionsCalculator {
    private static final String DEFAULT_ERROR_HANDLER_TYPE = "http://www.mulesoft.org/schema/mule/core/default-error-handler";

    @Override
    public List<EnumOption> options(AbstractFieldEditor editor, IMessageFlowNode node) {
        ArrayList<EnumOption> exceptionStrategies = new ArrayList<EnumOption>();
        IMuleProject muleProject = this.getMuleProject(editor);
        if (muleProject != null) {
            List configurations = muleProject.getConfigurationsCache().getConfigurations();
            for (MuleConfiguration muleConfiguration : configurations) {
                List flows = muleConfiguration.getFlows();
                for (Container container : flows) {
                    if (!container.getType().equals(DEFAULT_ERROR_HANDLER_TYPE)) continue;
                    exceptionStrategies.add(new EnumOption(container.getName()));
                }
            }
        }
        return exceptionStrategies;
    }

    protected IMuleProject getMuleProject(AbstractFieldEditor ed) {
        AttributeContext context;
        AttributesPropertyPage parentPage;
        if (ed != null && (parentPage = ed.getParentPage()) != null && (context = parentPage.getContext()) != null) {
            return context.getProject();
        }
        return null;
    }
}

