/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.endpoint;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.messageflow.module.CustomPageComposite;
import org.mule.tooling.messageflow.module.ICustomPage;
import org.mule.tooling.messageflow.module.IMessageFlowNodeAware;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.widgets.DynamicErrorMappingTable;
import org.mule.tooling.ui.modules.core.widgets.ErrorMapping;
import org.mule.tooling.ui.modules.core.widgets.meta.AbstractComponentMeta;
import org.mule.tooling.ui.modules.core.widgets.utils.ValidationMessageUtils;
import org.mule.tooling.ui.widgets.IMessageLogger;

public class ErrorMappingCustomPage
implements ICustomPage,
IMessageFlowNodeAware {
    public static final String ERROR_MAPPING_TITLE = "Error Mapping";
    private static final String DEFAULT_SOURCE_ANY = "ANY";
    public static final String TARGET_TYPE_ATTR = "targetType";
    public static final String SOURCE_TYPE_ATTR = "sourceType";
    public static final String ERROR_MAPPING_DEFINITION_ID = "http://www.mulesoft.org/schema/mule/core/error-mapping";
    private static final String ERROR_MAPPING_PROPERTY_COLLECTION_ID = PropertiesUtils.createCollectionId((String)"http://www.mulesoft.org/schema/mule/core/error-mapping");
    private CustomPageComposite container;
    private ScrolledComposite scrolledComposite;
    private Composite wrapper;
    private DynamicErrorMappingTable table;
    private boolean loading;
    private boolean loaded = false;
    private List<ErrorMappingElementPair> loadedMappings = Lists.newArrayList();
    private IMessageLogger messageLogger;
    private List<Message> errors = new ArrayList<Message>();
    private NodeDefinition nodeDefinition;
    private IMessageFlowNode node;
    private NestedDefinition mappingDefinition;

    public CustomPageComposite createControl(Composite parent) {
        this.container = new CustomPageComposite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)this.container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.container);
        Group containerGroup = new Group((Composite)this.container, 64);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)containerGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)containerGroup);
        this.scrolledComposite = new ScrolledComposite((Composite)containerGroup, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.scrolledComposite);
        this.wrapper = new Composite((Composite)this.scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().applyTo(this.wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.wrapper);
        this.scrolledComposite.setContent((Control)this.wrapper);
        this.createTable(this.wrapper);
        return this.container;
    }

    private void createTable(Composite parent) {
        this.table = new DynamicErrorMappingTable(this, 0, this.node);
        this.table.createControls();
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.table);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.table);
    }

    public void listChanged() {
        this.validate();
        this.relayout(this.scrolledComposite, this.wrapper);
        this.dirty();
    }

    public void mappingChanged() {
        this.validate();
        this.dirty();
    }

    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        this.loading = true;
        if (!this.loaded) {
            HashSet elements = Sets.newHashSet();
            Iterator iterator = node.getElement().getChildElements().iterator();
            iterator.forEachRemaining(e -> {
                boolean bl = elements.add(e);
            });
            for (String name : props.getPropertyCollectionNamesWithPrefix(ERROR_MAPPING_PROPERTY_COLLECTION_ID)) {
                PropertyCollectionMap propertyCollectionMap = props.getPropertyCollectionMap(name);
                String sourceType = propertyCollectionMap.getPropertiesMap().getProperty(SOURCE_TYPE_ATTR, DEFAULT_SOURCE_ANY);
                String targetType = propertyCollectionMap.getPropertiesMap().getProperty(TARGET_TYPE_ATTR, "");
                ErrorMapping mapping = this.table.createRow();
                mapping.createControl();
                mapping.setSourceType(sourceType);
                mapping.setTargetType(targetType);
                this.loadedMappings.add(new ErrorMappingElementPair(mapping, this.getElement(node, mapping.getProperties(), elements)));
                this.table.addRow(mapping);
            }
        }
        this.loaded = true;
        this.loading = false;
    }

    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        if (!this.loading) {
            List<ErrorMapping> mappings = this.table.getRows();
            this.cleanMappings(node, this.getDeletedMappings(mappings));
            int id = 1;
            for (ErrorMapping mapping : mappings) {
                this.saveMapping(node, props, mapping, id++);
            }
        }
    }

    private Set<ErrorMapping> getDeletedMappings(List<ErrorMapping> mappings) {
        HashSet deleted = Sets.newHashSet((Iterable)this.loadedMappings.stream().map(e -> e.getMapping()).collect(Collectors.toList()));
        mappings.forEach(m -> {
            boolean bl = deleted.remove(m);
        });
        return deleted;
    }

    private void cleanMappings(IMessageFlowNode node, Set<ErrorMapping> set) {
        PropertyCollection writablePropertyCollection = PropertiesUtils.toWritablePropertyCollection((IPropertyCollectionReadCapability)node.getProperties());
        writablePropertyCollection.getPropertyCollections().forEach(p -> {
            if (this.isErrorMapping((PropertyCollection)p) && this.existsMapping((PropertyCollection)p, set)) {
                p.setErased(true);
            }
        });
        node.setProperties(writablePropertyCollection);
    }

    private boolean existsMapping(PropertyCollection p, Set<ErrorMapping> mappings) {
        for (ErrorMapping mapping : mappings) {
            List properties;
            Set<Property> mappingProperties = mapping.getProperties();
            if (!mappingProperties.containsAll(properties = p.getProperties())) continue;
            return true;
        }
        return false;
    }

    private boolean isErrorMapping(PropertyCollection p) {
        return p.getName().startsWith(ERROR_MAPPING_PROPERTY_COLLECTION_ID);
    }

    private void saveMapping(IMessageFlowNode node, PropertyCollectionMap props, ErrorMapping mapping, int id) {
        IElementWrapper element = this.getOrCreateElement(node, mapping);
        PropertyCollectionMap prop = new PropertyCollectionMap(element);
        Set<Property> properties = mapping.getProperties();
        for (Property property : properties) {
            prop.addProperty(property);
        }
        String sourceType = mapping.getSourceType();
        if (sourceType.isEmpty() || sourceType.equals(DEFAULT_SOURCE_ANY)) {
            prop.addProperty("auxiliary;erased;sourceType", "true");
        }
        String name = PropertiesUtils.createCollectionIdWithSuffix((String)ERROR_MAPPING_DEFINITION_ID, (long)id);
        prop.setName(name);
        props.addPropertyCollection(name, prop);
        if (this.notLoaded(mapping)) {
            this.loadedMappings.add(new ErrorMappingElementPair(mapping, element));
        }
    }

    private boolean notLoaded(ErrorMapping mapping) {
        return !this.loadedMappings.stream().filter(m -> m.getMapping() == mapping).findAny().isPresent();
    }

    private IElementWrapper getOrCreateElement(IMessageFlowNode node, ErrorMapping mapping) {
        for (ErrorMappingElementPair e2 : this.loadedMappings) {
            if (e2.getMapping() != mapping) continue;
            return e2.getElement();
        }
        HashSet elements = Sets.newHashSet();
        node.getElement().getChildElements().forEach(e -> {
            boolean bl = elements.add(e);
        });
        IElementWrapper element = this.getElement(node, mapping.getProperties(), elements);
        if (element != null) {
            return element;
        }
        NodeDefinition errorMappingDefinition = this.getErrorMappingDefinition();
        int xmlOrder = ((AbstractComponentMeta)this.getNode().getDefinition().getService(AbstractComponentMeta.class)).getXmlOrder(ERROR_MAPPING_DEFINITION_ID);
        return MessageFlowUtils.createElement((IMessageFlowNode)node, (NodeDefinition)errorMappingDefinition, (int)xmlOrder);
    }

    public void addErrorMappingEntry(PropertyCollectionMap propertyCollectionMap) {
        if (propertyCollectionMap.getName().startsWith(ERROR_MAPPING_PROPERTY_COLLECTION_ID)) {
            ErrorMapping mapping = this.table.createRow();
            String sourceType = propertyCollectionMap.getPropertiesMap().getProperty(SOURCE_TYPE_ATTR, DEFAULT_SOURCE_ANY);
            String targetType = propertyCollectionMap.getPropertiesMap().getProperty(TARGET_TYPE_ATTR, "");
            mapping.createControl();
            mapping.setSourceType(sourceType);
            mapping.setTargetType(targetType);
            this.table.addRow(mapping);
        }
    }

    private IElementWrapper getElement(IMessageFlowNode node, Set<Property> properties, Set<IElementWrapper> elements) {
        for (IElementWrapper element : elements) {
            QName qName = element.getQName();
            if (!qName.getLocalPart().equals("error-mapping")) continue;
            IAttributeWrapper sourceTypeAttr = element.getAttribute(SOURCE_TYPE_ATTR);
            IAttributeWrapper targetTypeAttr = element.getAttribute(TARGET_TYPE_ATTR);
            String sourceType = sourceTypeAttr != null ? sourceTypeAttr.getText() : DEFAULT_SOURCE_ANY;
            String targetType = targetTypeAttr != null ? targetTypeAttr.getText() : "";
            boolean sameSource = true;
            boolean sameTarget = true;
            for (Property property : properties) {
                if (property.getName().equals(SOURCE_TYPE_ATTR) && !property.getValue().equals(sourceType)) {
                    sameSource = false;
                }
                if (!property.getName().equals(TARGET_TYPE_ATTR) || property.getValue().equals(targetType)) continue;
                sameTarget = false;
            }
            if (!sameSource || !sameTarget) continue;
            elements.remove(element);
            return element;
        }
        return null;
    }

    public String getTitle() {
        return ERROR_MAPPING_TITLE;
    }

    public String getDescription() {
        return "Map error types to a custom type";
    }

    private void relayout(ScrolledComposite scrolledComposite, Composite contributed) {
        this.table.requestLayout();
        Point panelSize = contributed.computeSize(-1, -1);
        scrolledComposite.setMinSize(panelSize.x, panelSize.y);
        scrolledComposite.layout(true, true);
    }

    public boolean accepts(IMessageFlowNode node) {
        AbstractComponentMeta service;
        NestedDefinition errorMappingDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(ERROR_MAPPING_DEFINITION_ID);
        NodeDefinition definition = node.getDefinition();
        if (definition != null && (service = (AbstractComponentMeta)definition.getService(AbstractComponentMeta.class)) != null) {
            return service.isExplicitlyAllowed(errorMappingDefinition);
        }
        return false;
    }

    public void validate() {
        this.table.validate();
        if (this.messageLogger != null) {
            this.errors = this.table.getErrors().stream().map(messageText -> MessageBuilder.newErrorMessage((String)messageText).build()).collect(Collectors.toList());
            if (!this.errors.isEmpty()) {
                this.messageLogger.setMessages(ValidationMessageUtils.asValidationMessages(this.errors));
            }
        }
    }

    protected void dirty() {
        if (!this.container.isDisposed()) {
            // empty if block
        }
    }

    public Composite getWrapper() {
        return this.wrapper;
    }

    public void setMessageLogger(IMessageLogger messageLogger) {
        this.messageLogger = messageLogger;
    }

    public NodeDefinition getNodeDefinition() {
        if (this.nodeDefinition == null) {
            this.setNodeDefinition(CoreUtils.getAnyDefinition((IMessageFlowNode)this.node));
        }
        return this.nodeDefinition;
    }

    private NodeDefinition getErrorMappingDefinition() {
        if (this.mappingDefinition == null) {
            this.mappingDefinition = MuleCorePlugin.getModuleManager().getNestedDefinition(ERROR_MAPPING_DEFINITION_ID);
        }
        return this.mappingDefinition;
    }

    public void setNodeDefinition(NodeDefinition nodeDefinition) {
        this.nodeDefinition = nodeDefinition;
    }

    public IMessageFlowNode getNode() {
        return this.node;
    }

    public void setNode(IMessageFlowNode node) {
        this.node = node;
    }

    private static class ErrorMappingElementPair {
        private ErrorMapping mapping;
        private IElementWrapper element;

        public ErrorMappingElementPair(ErrorMapping mapping, IElementWrapper element) {
            this.mapping = mapping;
            this.element = element;
        }

        public IElementWrapper getElement() {
            return this.element;
        }

        public ErrorMapping getMapping() {
            return this.mapping;
        }
    }
}

