/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.dsl;

import com.google.common.base.Optional;
import java.util.List;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.ui.modules.core.dsl.AbstractFlowBuilder;
import org.mule.tooling.ui.modules.core.dsl.AbstractPipelineBuilder;
import org.mule.tooling.ui.modules.core.dsl.DSLMuleConfigurationProvider;
import org.mule.tooling.ui.modules.core.dsl.FlowNestedContainerBuilder;
import org.mule.tooling.ui.modules.core.dsl.MessageFlowEntityBuilder;
import org.mule.tooling.ui.modules.core.dsl.MuleConfigurationBuilder;

public class SubFlowBuilder
extends AbstractFlowBuilder {
    protected MuleConfigurationBuilder configBuilder;

    protected SubFlowBuilder(MuleConfigurationBuilder configBuilder, String name) {
        super(new DSLMuleConfigurationProvider((MuleConfiguration)configBuilder.getConfig().getEntity()));
        this.configBuilder = configBuilder;
        ContainerDefinition definition = (ContainerDefinition)MuleCorePlugin.getModuleManager().getDefinition("http://www.mulesoft.org/schema/mule/core/sub-flow");
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)((MuleConfiguration)configBuilder.getConfig().getEntity()));
        Container createContainer = MessageFlowFactory.createContainer((IFlowTransformerContext)context, null, (ContainerDefinition)definition);
        createContainer.setName(name);
        this.flowModel = createContainer;
        this.setCurrentNestedBuilder(new FlowNestedContainerBuilder<MessageFlowEntityBuilder>(this, (NestedContainer)this.flowModel.getLanes().get(0)));
        this.setCurrentElement((MessageFlowEntity)this.flowModel);
    }

    protected SubFlowBuilder(MuleConfigurationBuilder configBuilder, Container flowModel) {
        super(new DSLMuleConfigurationProvider((MuleConfiguration)configBuilder.getConfig().getEntity()));
        this.flowModel = flowModel;
        this.configBuilder = configBuilder;
        this.setCurrentElement((MessageFlowEntity)flowModel);
        this.setCurrentNestedBuilder(new FlowNestedContainerBuilder<MessageFlowEntityBuilder>(this, (NestedContainer)flowModel.getLanes().get(0)));
        List lanes = flowModel.getLanes();
        if (!lanes.isEmpty()) {
            this.currentContainerStack.push(new CompartmentLaneDecorator((CompartmentLane)lanes.get(0), false));
            for (CompartmentLane compartmentLane : lanes) {
                this.addAllElementsIn(compartmentLane);
            }
        } else {
            CompartmentLane compartmentLane = new CompartmentLane();
            lanes.add(compartmentLane);
            CompartmentLaneDecorator compartmentLaneDecorator = new CompartmentLaneDecorator(compartmentLane, false);
            this.currentContainerStack.push(compartmentLaneDecorator);
        }
    }

    @Override
    public MuleConfigurationBuilder end() {
        this.setCurrentElement((MessageFlowEntity)this.flowModel);
        this.configBuilder.onContainerEnd((MessageFlowEntity)this.getModel());
        return this.configBuilder;
    }

    @Override
    protected MessageFlowEntity getCurrentElement() {
        return this.getCurrentNestedBuilder().getCurrentElement();
    }

    @Override
    protected EntityDecorator<?> getCurrentContainer() {
        return this.getCurrentNestedBuilder().getCurrentContainer();
    }

    @Override
    protected void pushContainer(CompartmentLane routeLane) {
        this.getCurrentNestedBuilder().pushContainer(routeLane);
    }

    @Override
    protected void pushContainer(SplitterNode all) {
        this.getCurrentNestedBuilder().pushContainer(all);
    }

    @Override
    protected void addElement(String name, MessageFlowEntity element) {
        this.getCurrentNestedBuilder().addElement(name, element);
    }

    @Override
    public MessageFlowEntity getElement(String name) {
        Optional<MessageFlowEntity> element = this.getCurrentNestedBuilder().getElementOpt(name);
        return (MessageFlowEntity)element.orNull();
    }

    @Override
    public AbstractPipelineBuilder<MuleConfigurationBuilder> after(String entityName) {
        this.getCurrentNestedBuilder().setAfter(this.getElement(entityName));
        return this;
    }

    @Override
    public AbstractPipelineBuilder<MuleConfigurationBuilder> before(String entityName) {
        this.getCurrentNestedBuilder().setBefore(this.getElement(entityName));
        return this;
    }
}

