/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.dsl;

import java.util.List;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.modules.core.dsl.IPropertyCollectionAware;

public class PropertyCollectionMapBuilder<T extends IPropertyCollectionAware> {
    private PropertyCollectionMap properties;
    private PropertyCollectionMapBuilder<T> parent;
    private T flowBuilder;

    public PropertyCollectionMapBuilder(PropertyCollectionMap properties, T flowBuilder, PropertyCollectionMapBuilder<T> parent) {
        this.properties = properties;
        this.flowBuilder = flowBuilder;
        this.parent = parent;
    }

    public PropertyCollectionMapBuilder<T> clear() {
        PropertyCollection asPropertyCollection = this.properties.asPropertyCollection();
        this.clear(asPropertyCollection);
        return this;
    }

    protected void clear(PropertyCollection asPropertyCollection) {
        List simpleProperties = asPropertyCollection.getProperties();
        for (Property property : simpleProperties) {
            this.properties.removeProperty(property.getName());
        }
        List propertyCollections = asPropertyCollection.getPropertyCollections();
        for (PropertyCollection propertyCollection : propertyCollections) {
            this.clear(propertyCollection);
        }
    }

    public PropertyCollectionMapBuilder<T> property(String name, Object value) {
        this.properties.addProperty(name, String.valueOf(value));
        return this;
    }

    public PropertyCollectionMapBuilder<T> remove(String name) {
        this.properties.removeProperty(name);
        return this;
    }

    public PropertyCollectionMapBuilder<T> editSubProperties(String key) {
        String propertyCollectionId = PropertiesUtils.createCollectionId((String)key);
        List propertiesList = this.properties.asPropertyCollection().getPropertyCollections();
        for (PropertyCollection property : propertiesList) {
            if (!property.getName().startsWith(propertyCollectionId)) continue;
            return new PropertyCollectionMapBuilder<T>(this.properties.getPropertyCollectionMap(property.getName()), this.flowBuilder, this);
        }
        return null;
    }

    public PropertyCollectionMapBuilder<T> removeSubPropertiesStartingWith(String name) {
        List propertiesList = this.properties.asPropertyCollection().getPropertyCollections();
        for (PropertyCollection property : propertiesList) {
            if (!property.getName().startsWith(name)) continue;
            this.properties.erasedPropertyCollectionMap(property.getName());
        }
        return this;
    }

    public PropertyCollectionMapBuilder<T> subProperties(String name) {
        if (!name.startsWith("@")) {
            name = PropertiesUtils.createCollectionIdWithSuffix((String)name, (long)this.properties.getPropertiesMap().keySet().size());
        }
        PropertyCollectionMap supProperties = new PropertyCollectionMap();
        supProperties.setName(name);
        this.properties.addPropertyCollection(name, supProperties);
        return new PropertyCollectionMapBuilder<T>(supProperties, this.flowBuilder, this);
    }

    public PropertyCollectionMapBuilder<T> endSubProperties() {
        return this.parent;
    }

    public T endProperties() {
        this.flowBuilder.setProperties(this.properties.asPropertyCollection());
        return this.flowBuilder;
    }

    public String propertyValue(String propertyName) {
        return this.properties.getProperty(propertyName, null);
    }
}

