/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.dsl;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.cache.MuleConfigurationUtils;
import org.mule.tooling.core.dom.DOMFactory;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.MuleConfigurationDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.GlobalDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.dsl.AbstractFlowBuilder;
import org.mule.tooling.ui.modules.core.dsl.AbstractPipelineBuilder;
import org.mule.tooling.ui.modules.core.dsl.ContainerBuilder;
import org.mule.tooling.ui.modules.core.dsl.DSLMuleConfigurationProvider;
import org.mule.tooling.ui.modules.core.dsl.ExceptionStrategyBuilder;
import org.mule.tooling.ui.modules.core.dsl.FlowBuilder;
import org.mule.tooling.ui.modules.core.dsl.GlobalElementBuilder;
import org.mule.tooling.ui.modules.core.dsl.IPropertyCollectionAware;
import org.mule.tooling.ui.modules.core.dsl.MessageFlowEntityBuilder;
import org.mule.tooling.ui.modules.core.dsl.PropertyCollectionMapBuilder;
import org.mule.tooling.ui.modules.core.dsl.SubFlowBuilder;
import org.w3c.dom.Document;

public class MuleConfigurationBuilder
extends MessageFlowEntityBuilder
implements IPropertyCollectionAware {
    private MuleConfigurationDecorator config;
    private Map<String, AbstractFlowBuilder> flowBuilders = new HashMap<String, AbstractFlowBuilder>();
    private Map<String, ContainerBuilder<?>> containerBuilders = new HashMap();
    private Map<String, GlobalElementBuilder> globalElementBuilders = new HashMap<String, GlobalElementBuilder>();

    public MuleConfigurationBuilder(String name, String description, ISchemaLocationLookup schemaLocationLookup) {
        super(null);
        IDOMDocument document = null;
        try {
            IDOMModel domModel = MuleConfigurationUtils.getDomModel((String)CoreUtils.getEmptyConfigContents((MuleProjectKind)MuleProjectKind.APPLICATION, (boolean)true), (String)(StringUtils.isBlank((String)name) || !name.endsWith(".xml") ? "config.xml" : name), (Charset)IMuleResources.DEFAULT_CHARSET);
            document = domModel.getDocument();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MuleConfiguration configModel = new MuleConfiguration(DOMFactory.from((Document)document, (ISchemaLocationLookup)schemaLocationLookup));
        configModel.setName(name);
        configModel.setDescription(description);
        configModel.setEntityId(UUID.randomUUID().toString());
        this.config = new MuleConfigurationDecorator(configModel);
        this.muleConfigurationProvider = new DSLMuleConfigurationProvider((MuleConfiguration)this.config.getEntity());
        this.setCurrentElement((MessageFlowEntity)configModel);
    }

    public MuleConfigurationBuilder(MuleConfigurationDecorator config) {
        super(new DSLMuleConfigurationProvider((MuleConfiguration)config.getEntity()));
        this.config = config;
        this.reload();
    }

    public void reload() {
        this.clear();
        List flows = this.getConfig().getFlows();
        List containers = CoreUtils.filterByType((Iterable)flows, Container.class);
        for (Container container : containers) {
            if (ModelUtils.isFlow((IMessageFlowEntity)container)) {
                this.getFlowBuilders().put(container.getName(), new FlowBuilder(this, container));
                continue;
            }
            if (ModelUtils.isSubflow((IMessageFlowEntity)container)) {
                this.getFlowBuilders().put(container.getName(), new SubFlowBuilder(this, container));
                continue;
            }
            if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)container)) {
                this.getContainerBuilders().put(container.getName(), new ExceptionStrategyBuilder(this, container));
                continue;
            }
            this.getContainerBuilders().put(container.getName(), new ContainerBuilder<MuleConfigurationBuilder>(this, container));
        }
        List globalEntries = ((MuleConfiguration)this.getConfig().getEntity()).getGlobalEntries();
        List globalElements = CoreUtils.filterByType((Iterable)globalEntries, GlobalElement.class);
        for (GlobalElement globalElement : globalElements) {
            this.getGlobalElementBuilders().put(globalElement.getName(), new GlobalElementBuilder(this, globalElement));
        }
        this.setCurrentElement((MessageFlowEntity)this.getConfig().getEntity());
    }

    private void clear() {
        this.getFlowBuilders().clear();
        this.getContainerBuilders().clear();
        this.getGlobalElementBuilders().clear();
    }

    public FlowBuilder addFlow(String name) {
        FlowBuilder flowBuilder = new FlowBuilder(this, name);
        this.doAddFlow(flowBuilder);
        return flowBuilder;
    }

    protected NodeDefinition getDefinitionByType(String type) {
        return MuleCorePlugin.getModuleManager().getDefinition(type);
    }

    public ContainerBuilder<MuleConfigurationBuilder> addContainer(String name, String type) {
        ContainerDefinition containerDefinition = (ContainerDefinition)this.getDefinitionByType(type);
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)((MuleConfiguration)this.config.getEntity()));
        Container createContainer = MessageFlowFactory.createContainer((IFlowTransformerContext)context, (MuleConfiguration)((MuleConfiguration)this.getConfig().getEntity()), (ContainerDefinition)containerDefinition);
        createContainer.setName(name);
        ContainerBuilder<MuleConfigurationBuilder> containerBuilder = new ContainerBuilder<MuleConfigurationBuilder>(this, createContainer);
        this.config.addFlow(createContainer);
        this.getContainerBuilders().put(name, containerBuilder);
        return containerBuilder;
    }

    public AbstractFlowBuilder addSubFlow(String name) {
        SubFlowBuilder flowBuilder = new SubFlowBuilder(this, name);
        this.doAddFlow(flowBuilder);
        return flowBuilder;
    }

    public AbstractFlowBuilder editFlow(String name) {
        AbstractFlowBuilder flowBuilder = this.getFlowBuilders().get(name);
        if (flowBuilder == null) {
            return null;
        }
        flowBuilder.edit();
        return flowBuilder;
    }

    public ContainerBuilder<?> editContainer(String name) {
        return this.getContainerBuilders().get(name);
    }

    public Container getFlow(String name) {
        AbstractFlowBuilder flowBuilder = this.getFlowBuilders().get(name);
        return flowBuilder == null ? null : flowBuilder.getModel();
    }

    public Container getContainer(String name) {
        ContainerBuilder<?> containerBuilder = this.getContainerBuilders().get(name);
        return containerBuilder == null ? null : containerBuilder.getModel();
    }

    public GlobalElementBuilder addHttpGlobalElement(String name) {
        return this.addGlobalElement("http://www.mulesoft.org/schema/mule/http/connector", name);
    }

    public GlobalElementBuilder addGlobalElement(String type, String name) {
        GlobalDefinition globalElementDefinition = this.getGlobalDefinition(type);
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)((MuleConfiguration)this.config.getEntity()));
        GlobalElement createGlobalElement = MessageFlowFactory.createGlobalElement((IFlowTransformerContext)context, (GlobalDefinition)globalElementDefinition);
        createGlobalElement.setName(name);
        createGlobalElement.setProperties(new PropertyCollection());
        this.config.addGlobal(createGlobalElement);
        return new GlobalElementBuilder(this, createGlobalElement);
    }

    protected GlobalDefinition getGlobalDefinition(String endpointType) {
        return MuleCorePlugin.getModuleManager().getGlobalDefinition(endpointType);
    }

    public GlobalElementBuilder editGlobalElement(String name) {
        GlobalElementBuilder globalElement = this.getGlobalElementBuilders().get(name);
        if (globalElement == null) {
            throw new IllegalArgumentException("Global element with name '" + name + "' is not defined");
        }
        return globalElement;
    }

    public MessageFlowEntityBuilder removeGlobalElement(String name) {
        GlobalElementBuilder globalElement = this.getGlobalElementBuilders().get(name);
        if (globalElement == null) {
            throw new IllegalArgumentException("Global element with name '" + name + "' is not defined");
        }
        this.config.removeGlobal((IMessageFlowEntity)globalElement.getModel());
        return this;
    }

    public PropertyCollectionMapBuilder<MuleConfigurationBuilder> usingProperties() {
        try {
            Class<?> elementClass = this.getCurrentElement().getClass();
            Method getPropretiesMethod = elementClass.getMethod("getProperties", new Class[0]);
            PropertyCollection propertyCollection = (PropertyCollection)getPropretiesMethod.invoke((Object)this.getCurrentElement(), new Object[0]);
            return new PropertyCollectionMapBuilder<MuleConfigurationBuilder>(new PropertyCollectionMap(propertyCollection), this, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Set properties is not supported for " + String.valueOf(this.getCurrentElement().getClass()), e);
        }
    }

    @Override
    public void setProperties(PropertyCollection properties) {
        AbstractPipelineBuilder.populateSubPropertiesElements(properties, (IMessageFlowNode)this.getCurrentElement());
        Class<?> elementClass = this.getCurrentElement().getClass();
        try {
            Method setPropretiesMethod = elementClass.getMethod("setProperties", PropertyCollection.class);
            setPropretiesMethod.invoke((Object)this.getCurrentElement(), properties);
        }
        catch (Exception e) {
            throw new RuntimeException("Set properties is not supported for " + String.valueOf(this.getCurrentElement().getClass()), e);
        }
    }

    private void doAddFlow(AbstractFlowBuilder flow) {
        this.config.addFlow(flow.getModel());
        this.getFlowBuilders().put(flow.getModel().getName(), flow);
    }

    public MuleConfigurationDecorator getConfig() {
        return this.config;
    }

    public ContainerBuilder<MuleConfigurationBuilder> addBatch(String name) {
        return this.addContainer(name, "http://www.mulesoft.org/schema/mule/batch/job");
    }

    public Map<String, ContainerBuilder<?>> getContainerBuilders() {
        return this.containerBuilders;
    }

    public Map<String, AbstractFlowBuilder> getFlowBuilders() {
        return this.flowBuilders;
    }

    public Map<String, GlobalElementBuilder> getGlobalElementBuilders() {
        return this.globalElementBuilders;
    }

    public MessageFlowEntity getGlobalElement(String elementName) {
        return this.getGlobalElementBuilders().get(elementName).getModel();
    }
}

