/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.dsl;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.ui.modules.core.dsl.AbstractFlowBuilder;
import org.mule.tooling.ui.modules.core.dsl.AbstractPipelineBuilder;
import org.mule.tooling.ui.modules.core.dsl.DSLMuleConfigurationProvider;
import org.mule.tooling.ui.modules.core.dsl.FlowNestedContainerBuilder;
import org.mule.tooling.ui.modules.core.dsl.MessageFlowEntityBuilder;
import org.mule.tooling.ui.modules.core.dsl.MuleConfigurationBuilder;
import org.mule.tooling.utils.Pair;

public class FlowBuilder
extends AbstractFlowBuilder {
    protected MuleConfigurationBuilder configBuilder;
    private FlowNestedContainerBuilder<MessageFlowEntityBuilder> inputContainerBuilder;
    private FlowNestedContainerBuilder<MessageFlowEntityBuilder> processContainerBuilder;
    private FlowNestedContainerBuilder<MessageFlowEntityBuilder> esContainerBuilder;

    protected FlowBuilder(MuleConfigurationBuilder configBuilder, String name) {
        super(new DSLMuleConfigurationProvider((MuleConfiguration)configBuilder.getConfig().getEntity()));
        this.configBuilder = configBuilder;
        ContainerDefinition definition = (ContainerDefinition)MuleCorePlugin.getModuleManager().getDefinition("http://www.mulesoft.org/schema/mule/core/flow");
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)((MuleConfiguration)configBuilder.getConfig().getEntity()));
        Container createContainer = MessageFlowFactory.createContainer((IFlowTransformerContext)context, null, (ContainerDefinition)definition);
        createContainer.setName(name);
        this.flowModel = createContainer;
        this.inputContainerBuilder = new FlowNestedContainerBuilder(this, (NestedContainer)this.flowModel.getLanes().get(0));
        this.processContainerBuilder = new FlowNestedContainerBuilder(this, (NestedContainer)this.flowModel.getLanes().get(1));
        this.esContainerBuilder = new FlowNestedContainerBuilder(this, (NestedContainer)this.flowModel.getLanes().get(2));
        this.setCurrentElement((MessageFlowEntity)this.flowModel);
    }

    protected FlowBuilder(MuleConfigurationBuilder configBuilder, Container flowModel) {
        super(new DSLMuleConfigurationProvider((MuleConfiguration)configBuilder.getConfig().getEntity()));
        this.flowModel = flowModel;
        this.inputContainerBuilder = new FlowNestedContainerBuilder(this, (NestedContainer)flowModel.getLanes().get(0));
        this.processContainerBuilder = new FlowNestedContainerBuilder(this, (NestedContainer)flowModel.getLanes().get(1));
        this.esContainerBuilder = new FlowNestedContainerBuilder(this, (NestedContainer)flowModel.getLanes().get(2));
        this.configBuilder = configBuilder;
        List lanes = flowModel.getLanes();
        if (!lanes.isEmpty()) {
            this.currentContainerStack.push(new CompartmentLaneDecorator((CompartmentLane)lanes.get(0), false));
            for (CompartmentLane compartmentLane : lanes) {
                this.addAllElementsIn(compartmentLane);
            }
        } else {
            CompartmentLane compartmentLane = new CompartmentLane();
            lanes.add(compartmentLane);
            CompartmentLaneDecorator compartmentLaneDecorator = new CompartmentLaneDecorator(compartmentLane, false);
            this.currentContainerStack.push(compartmentLaneDecorator);
        }
    }

    @Override
    public FlowBuilder asFlow() {
        return this;
    }

    public FlowNestedContainerBuilder<MessageFlowEntityBuilder> getInputContainerBuilder() {
        return this.inputContainerBuilder;
    }

    public FlowNestedContainerBuilder<MessageFlowEntityBuilder> getProcessContainerBuilder() {
        return this.processContainerBuilder;
    }

    public FlowNestedContainerBuilder<MessageFlowEntityBuilder> getEsContainerBuilder() {
        return this.esContainerBuilder;
    }

    @Override
    protected AbstractFlowBuilder edit() {
        this.setCurrentNestedBuilder(null);
        return super.edit();
    }

    @Override
    public MuleConfigurationBuilder end() {
        this.setCurrentElement((MessageFlowEntity)this.flowModel);
        this.configBuilder.onContainerEnd((MessageFlowEntity)this.getModel());
        return this.configBuilder;
    }

    @Override
    protected MessageFlowEntity getCurrentElement() {
        if (this.getCurrentNestedBuilder() == null) {
            return super.getCurrentElement();
        }
        return this.getCurrentNestedBuilder().getCurrentElement();
    }

    @Override
    protected void addElement(String name, MessageFlowEntity element) {
        if (this.getCurrentNestedBuilder() == null || this.getCurrentNestedBuilder().isAtRootLevel()) {
            if (this.shouldAddInsideESNestedContainer(element)) {
                this.esContainerBuilder.addElement(name, element);
                this.setCurrentNestedBuilder(this.esContainerBuilder);
            } else if (ModelUtils.isMessageSource((IMessageFlowEntity)element)) {
                this.inputContainerBuilder.addElement(name, element);
                this.setCurrentNestedBuilder(this.inputContainerBuilder);
            } else {
                this.processContainerBuilder.addElement(name, element);
                this.setCurrentNestedBuilder(this.processContainerBuilder);
            }
        } else {
            this.getCurrentNestedBuilder().addElement(name, element);
        }
    }

    private boolean shouldAddInsideESNestedContainer(MessageFlowEntity element) {
        boolean isES = MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)element);
        boolean esContainerIsCurrentOne = this.esContainerBuilder.equals(this.getCurrentNestedBuilder());
        return isES || esContainerIsCurrentOne;
    }

    @Override
    protected EntityDecorator<?> getCurrentContainer() {
        return this.getCurrentNestedBuilder().getCurrentContainer();
    }

    @Override
    protected void pushContainer(CompartmentLane routeLane) {
        this.getCurrentNestedBuilder().pushContainer(routeLane);
    }

    @Override
    protected void pushContainer(SplitterNode all) {
        this.getCurrentNestedBuilder().pushContainer(all);
    }

    @Override
    public MessageFlowEntity getElement(String name) {
        Optional<MessageFlowEntity> fromInput = this.inputContainerBuilder.getElementOpt(name);
        Optional<MessageFlowEntity> fromProcess = this.processContainerBuilder.getElementOpt(name);
        Optional<MessageFlowEntity> fromES = this.esContainerBuilder.getElementOpt(name);
        return (MessageFlowEntity)fromInput.or(fromProcess).or(fromES).orNull();
    }

    @Override
    public AbstractPipelineBuilder<MuleConfigurationBuilder> editElement(String name) {
        return super.editElement(name);
    }

    private Pair<FlowNestedContainerBuilder<MessageFlowEntityBuilder>, MessageFlowEntity> findContainerAndEntityOf(String name) {
        return (Pair)this.getContainerAndEntity(this.inputContainerBuilder, name).or(this.getContainerAndEntity(this.processContainerBuilder, name)).or(this.getContainerAndEntity(this.esContainerBuilder, name)).orNull();
    }

    private FlowNestedContainerBuilder<MessageFlowEntityBuilder> getNestedBuilderOf(MessageFlowEntity entity) {
        ArrayList builders = Lists.newArrayList((Object[])new FlowNestedContainerBuilder[]{this.inputContainerBuilder, this.processContainerBuilder, this.esContainerBuilder});
        for (FlowNestedContainerBuilder builder : builders) {
            if (!builder.contains(entity)) continue;
            return builder;
        }
        throw new RuntimeException("Couldn't find entity: " + String.valueOf(entity));
    }

    private Optional<Pair<FlowNestedContainerBuilder<MessageFlowEntityBuilder>, MessageFlowEntity>> getContainerAndEntity(FlowNestedContainerBuilder<MessageFlowEntityBuilder> builder, String name) {
        Optional<MessageFlowEntity> entity = builder.getElementOpt(name);
        if (entity.isPresent()) {
            return Optional.of((Object)Pair.of(builder, (Object)((MessageFlowEntity)entity.get())));
        }
        return Optional.absent();
    }

    @Override
    public AbstractPipelineBuilder<MuleConfigurationBuilder> editElement(MessageFlowEntity entity) {
        FlowNestedContainerBuilder<MessageFlowEntityBuilder> nestedBuilder = this.getNestedBuilderOf(entity);
        this.setCurrentNestedBuilder(nestedBuilder);
        this.getCurrentNestedBuilder().editElement(entity);
        return this;
    }

    @Override
    public AbstractPipelineBuilder<MuleConfigurationBuilder> after(String entityName) {
        Pair<FlowNestedContainerBuilder<MessageFlowEntityBuilder>, MessageFlowEntity> pair = this.findContainerAndEntityOf(entityName);
        ((FlowNestedContainerBuilder)pair.getLeft()).setAfter((MessageFlowEntity)pair.getRight());
        return this;
    }

    @Override
    public AbstractPipelineBuilder<MuleConfigurationBuilder> before(String entityName) {
        Pair<FlowNestedContainerBuilder<MessageFlowEntityBuilder>, MessageFlowEntity> pair = this.findContainerAndEntityOf(entityName);
        ((FlowNestedContainerBuilder)pair.getLeft()).setBefore((MessageFlowEntity)pair.getRight());
        return this;
    }
}

