/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.dsl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.dsl.AbstractPipelineBuilder;
import org.mule.tooling.ui.modules.core.dsl.IPropertyCollectionAware;
import org.mule.tooling.ui.modules.core.dsl.MessageFlowEntityBuilder;
import org.mule.tooling.ui.modules.core.dsl.NestedContainerBuilder;
import org.mule.tooling.ui.modules.core.dsl.PropertyCollectionMapBuilder;

public class ContainerBuilder<T extends MessageFlowEntityBuilder>
implements IPropertyCollectionAware {
    private Container model;
    private T configBuilder;

    public ContainerBuilder(T configBuilder, Container model) {
        this.model = model;
        this.configBuilder = configBuilder;
    }

    public T getConfigBuilder() {
        return this.configBuilder;
    }

    public NestedContainerBuilder<T> editNested(int index) {
        return new NestedContainerBuilder(this, (NestedContainer)this.model.getLanes().get(index));
    }

    public NestedContainerBuilder<T> editNested(String type) {
        List lanes = this.model.getLanes();
        for (CompartmentLane compartmentLane : lanes) {
            NestedContainer nestedContainer = (NestedContainer)compartmentLane;
            if (!nestedContainer.getType().equals(type)) continue;
            return new NestedContainerBuilder(this, nestedContainer);
        }
        return null;
    }

    public T end() {
        ((MessageFlowEntityBuilder)this.configBuilder).onContainerEnd((MessageFlowEntity)this.model);
        return this.configBuilder;
    }

    public Container getModel() {
        return this.model;
    }

    public PropertyCollectionMapBuilder<ContainerBuilder<T>> usingProperties() {
        PropertyCollection propertyCollection = this.getModel().getPropertiesForEdit(this.getModel().getElement());
        return new PropertyCollectionMapBuilder<ContainerBuilder<T>>(new PropertyCollectionMap(propertyCollection), this, null);
    }

    public ContainerBuilder<T> using(Map<String, Object> properties) {
        PropertyCollectionMapBuilder<ContainerBuilder<T>> propertiesBuilder = this.usingProperties();
        this.addProperties(properties, propertiesBuilder);
        return this;
    }

    @Override
    public void setProperties(PropertyCollection properties) {
        AbstractPipelineBuilder.populateSubPropertiesElements(properties, (IMessageFlowNode)this.getModel());
        this.getModel().setProperties(properties);
    }

    protected void addProperties(Map<String, Object> properties, PropertyCollectionMapBuilder<ContainerBuilder<T>> propertiesBuilder) {
        Set<Map.Entry<String, Object>> entrySet = properties.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (entry.getValue() instanceof Map) {
                propertiesBuilder.subProperties(entry.getKey());
                this.addProperties((Map)entry.getValue(), propertiesBuilder);
                propertiesBuilder.endSubProperties();
                continue;
            }
            propertiesBuilder.property(entry.getKey(), entry.getValue());
        }
    }
}

