/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.dsl;

import com.google.common.base.Optional;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.messageflow.IXmlOrder;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.generator.IFlowTransformerContext;
import org.mule.tooling.core.generator.NewFlowTransformerContext;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.CommentContainer;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.GlobalUnknown;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageExchangePattern;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowFactory;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.PatternNode;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.UnknownNode;
import org.mule.tooling.model.messageflow.decorator.CompartmentDecorator;
import org.mule.tooling.model.messageflow.decorator.CompartmentLaneDecorator;
import org.mule.tooling.model.messageflow.decorator.EntityDecorator;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.model.messageflow.decorator.SplitterDecorator;
import org.mule.tooling.model.messageflow.util.IMuleConfigurationProvider;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.EndpointDefinition;
import org.mule.tooling.model.module.NestedDefinition;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.model.module.RouteDefinition;
import org.mule.tooling.ui.modules.core.dsl.ContainerBuilder;
import org.mule.tooling.ui.modules.core.dsl.IPropertyCollectionAware;
import org.mule.tooling.ui.modules.core.dsl.MessageFlowEntityBuilder;
import org.mule.tooling.ui.modules.core.dsl.PropertyCollectionMapBuilder;

public abstract class AbstractPipelineBuilder<T>
extends MessageFlowEntityBuilder
implements IPropertyCollectionAware {
    public static final String UNKNOWN_ID = "unknown";
    public static final String COMMENT_ID = "comment";
    public static final String CONNECTOR = "Basic";
    public static final String SALESFORCE_CREATE_OPERATION = "http://www.mulesoft.org/schema/mule/sfdc/create";
    public static final String SALESFORCE_CREATE_SINGLE_OPERATION = "http://www.mulesoft.org/schema/mule/sfdc/create-single";
    public static final String SALESFORCE_RESET_UPDATED_OBJECTS_TIMESTAMP_OPERATION = "http://www.mulesoft.org/schema/mule/sfdc/reset-updated-objects-timestamp";
    public static final String PROP_EXPRESSION = "expression";
    protected Stack<EntityDecorator<?>> currentContainerStack = new Stack();
    private Map<String, MessageFlowEntity> modelElements = new HashMap<String, MessageFlowEntity>();
    private Map<String, CompartmentLaneDecorator<?>> modelElementContainer = new HashMap();
    private MessageFlowEntity after;
    private MessageFlowEntity before;

    public AbstractPipelineBuilder(IMuleConfigurationProvider muleConfigurationProvider) {
        super(muleConfigurationProvider);
    }

    public AbstractPipelineBuilder<T> withDescription(String description) {
        try {
            Method setDescription = this.getCurrentElement().getClass().getMethod("setDescription", String.class);
            setDescription.invoke((Object)this.getCurrentElement(), description);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Set description is not supported for " + String.valueOf(this.getCurrentElement().getClass()), e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public boolean isAtRootLevel() {
        return this.currentContainerStack.size() == 1;
    }

    public PropertyCollectionMapBuilder<AbstractPipelineBuilder<T>> usingProperties() {
        try {
            PropertyCollection propertyCollection = this.getPropertiesForEdit();
            return new PropertyCollectionMapBuilder<AbstractPipelineBuilder<T>>(new PropertyCollectionMap(propertyCollection), this, null);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Set properties is not supported for " + String.valueOf(this.getCurrentElement().getClass()), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Set properties is not supported for " + String.valueOf(this.getCurrentElement().getClass()), e);
        }
    }

    public PropertyCollectionMapBuilder<AbstractPipelineBuilder<T>> editProperties() {
        return this.usingProperties();
    }

    public IReadOnlyPropertyCollection getProperties() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> elementClass = this.getCurrentElement().getClass();
        Method getPropretiesMethod = elementClass.getMethod("getProperties", new Class[0]);
        IReadOnlyPropertyCollection propertyCollection = (IReadOnlyPropertyCollection)getPropretiesMethod.invoke((Object)this.getCurrentElement(), new Object[0]);
        return propertyCollection;
    }

    public PropertyCollection getPropertiesForEdit() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> elementClass = this.getCurrentElement().getClass();
        Method getPropretiesMethod = elementClass.getMethod("getPropertiesForEdit", IElementWrapper.class);
        PropertyCollection propertyCollection = (PropertyCollection)getPropretiesMethod.invoke((Object)this.getCurrentElement(), this.getCurrentElement().getElement());
        return propertyCollection;
    }

    public AbstractPipelineBuilder<T> using(Map<String, Object> properties) {
        PropertyCollectionMapBuilder<AbstractPipelineBuilder<T>> propertiesBuilder = this.usingProperties();
        this.addProperties(properties, propertiesBuilder);
        return this;
    }

    protected void addProperties(Map<String, Object> properties, PropertyCollectionMapBuilder<AbstractPipelineBuilder<T>> propertiesBuilder) {
        Set<Map.Entry<String, Object>> entrySet = properties.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (entry.getValue() instanceof Map) {
                propertiesBuilder.subProperties(entry.getKey());
                this.addProperties((Map)entry.getValue(), propertiesBuilder);
                propertiesBuilder.endSubProperties();
                continue;
            }
            propertiesBuilder.property(entry.getKey(), entry.getValue());
        }
    }

    protected void addAllElementsIn(CompartmentLane compartmentLane) {
        final CompartmentLaneDecorator parent = new CompartmentLaneDecorator(compartmentLane, false);
        for (IMessageFlowEntity element : compartmentLane.getCompartmentLaneEntries()) {
            element.accept((MessageFlowEntityVisitor)new MessageFlowEntityVisitorAdapter(){

                public void visitUnknownNode(UnknownNode unknownNode) {
                    AbstractPipelineBuilder.this.registerElement(AbstractPipelineBuilder.UNKNOWN_ID, (MessageFlowEntity)unknownNode, parent);
                }

                public void visitCommentNode(CommentContainer commentNode) {
                    AbstractPipelineBuilder.this.registerElement(AbstractPipelineBuilder.COMMENT_ID, (MessageFlowEntity)commentNode, parent);
                }

                public void visitSplitterNode(SplitterNode splitterNode) {
                    String name = splitterNode.getName();
                    AbstractPipelineBuilder.this.registerElement(name, (MessageFlowEntity)splitterNode, parent);
                    List lanes = splitterNode.getCompartment().getLanes();
                    this.addLanes(name, lanes);
                }

                private void addLanes(String name, List<CompartmentLane> lanes) {
                    int i = 0;
                    for (CompartmentLane scopeLane : lanes) {
                        AbstractPipelineBuilder.this.modelElements.put(name + "[" + i + "]", (MessageFlowEntity)scopeLane);
                        AbstractPipelineBuilder.this.addAllElementsIn(scopeLane);
                        ++i;
                    }
                }

                public void visitContainer(Container container) {
                    String name = container.getName();
                    AbstractPipelineBuilder.this.registerElement(name, (MessageFlowEntity)container, parent);
                    this.addLanes(name, container.getLanes());
                }

                public void visitPatternNode(PatternNode patternNode) {
                    AbstractPipelineBuilder.this.registerElement(patternNode.getName(), (MessageFlowEntity)patternNode, parent);
                }

                public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
                    AbstractPipelineBuilder.this.registerElement(muleConfiguration.getName(), (MessageFlowEntity)muleConfiguration, parent);
                }

                public void visitGlobalUnknown(GlobalUnknown globalUnknown) {
                    AbstractPipelineBuilder.this.registerElement(globalUnknown.getContent(), (MessageFlowEntity)globalUnknown, parent);
                }

                public void visitGlobalElement(GlobalElement globalElement) {
                    AbstractPipelineBuilder.this.registerElement(globalElement.getName(), (MessageFlowEntity)globalElement, parent);
                }

                public void visitEndpointNode(EndpointNode endpointNode) {
                    AbstractPipelineBuilder.this.registerElement(endpointNode.getName(), (MessageFlowEntity)endpointNode, parent);
                }

                public void visitCompartment(Compartment compartment) {
                }

                public void visitCompartmentLane(CompartmentLane lane) {
                }
            });
        }
    }

    public AbstractPipelineBuilder<T> editElement(String name) {
        MessageFlowEntity element = this.getElement(name);
        if (element == null) {
            throw new RuntimeException("Element not found : '" + name + "'");
        }
        this.editElement(element);
        return this;
    }

    public ContainerBuilder<AbstractPipelineBuilder<T>> editContainer(String name) {
        Container containerElement = (Container)this.getElement(name);
        this.setCurrentElement((MessageFlowEntity)containerElement);
        return new ContainerBuilder<AbstractPipelineBuilder<T>>(this, containerElement);
    }

    public AbstractPipelineBuilder<T> editElement(MessageFlowEntity entity) {
        this.setCurrentElement(entity);
        if (entity instanceof SplitterNode) {
            this.pushContainer((SplitterNode)entity);
        } else if (entity instanceof Container) {
            this.pushContainer((CompartmentLane)((Container)entity).getDefaultNestedContainer());
        }
        return this;
    }

    public AbstractPipelineBuilder<T> addLogger(String name) {
        return this.addPattern("http://www.mulesoft.org/schema/mule/core/logger", name);
    }

    public AbstractPipelineBuilder<T> addCollectionSplitter(String name) {
        return this.addPattern("http://www.mulesoft.org/schema/mule/core/collection-splitter", name);
    }

    public AbstractPipelineBuilder<T> addCollectionAggregator(String name) {
        return this.addPattern("http://www.mulesoft.org/schema/mule/core/collection-aggregator", name);
    }

    public AbstractPipelineBuilder<T> addHttpEndpoint(String name, MessageExchangePattern pattern, EndpointDirection direction) {
        return this.addEndpoint("http://www.mulesoft.org/schema/mule/http/endpoint", name, pattern, direction);
    }

    public AbstractPipelineBuilder<T> addCloudConnector(String name, String operation, String configName) {
        PatternNode cloudConnector = MessageFlowFactory.createPatternNode((IFlowTransformerContext)this.createContext(), (NodeDefinition)this.getDefinitionByType(operation));
        cloudConnector.setName(name);
        PropertyCollectionMap propertyCollectionMap = new PropertyCollectionMap(cloudConnector.getProperties());
        propertyCollectionMap.addProperty("config-ref", configName);
        propertyCollectionMap.addProperty("org.mule.tooling.ui.modules.core.widgets.meta.ModeAttribute", operation);
        cloudConnector.setProperties(propertyCollectionMap.asPropertyCollection());
        this.addElement(name, (MessageFlowEntity)cloudConnector);
        return this;
    }

    public AbstractPipelineBuilder<T> addChoice(String name) {
        return this.addSplitter("http://www.mulesoft.org/schema/mule/core/choice", name);
    }

    public AbstractPipelineBuilder<T> addAll(String name) {
        return this.addSplitter("http://www.mulesoft.org/schema/mule/core/all", name);
    }

    public AbstractPipelineBuilder<T> addScatterGather(String name) {
        return this.addSplitter("http://www.mulesoft.org/schema/mule/core/scatter-gather", name);
    }

    public AbstractPipelineBuilder<T> addSplitter(String splitterType, String name) {
        IFlowTransformerContext context = this.createContext();
        SplitterNode all = MessageFlowFactory.createSplitterNode((IFlowTransformerContext)context, (NodeDefinition)this.getDefinitionByType(splitterType));
        this.addElement(name, (MessageFlowEntity)all);
        all.setName(name);
        this.pushContainer(all);
        return this;
    }

    protected void pushContainer(SplitterNode all) {
        this.currentContainerStack.push((EntityDecorator<?>)new SplitterDecorator(all));
    }

    protected void pushContainer(CompartmentLane routeLane) {
        this.currentContainerStack.push((EntityDecorator<?>)new CompartmentLaneDecorator(routeLane, false));
    }

    public AbstractPipelineBuilder<T> addRoute() {
        SplitterDecorator router = (SplitterDecorator)this.getCurrentContainer();
        IFlowTransformerContext context = this.createContext();
        context.getEntityStack().push((MessageFlowEntity)router.getEntity());
        CompartmentLane routeLane = MessageFlowFactory.createCompartmentLane((IFlowTransformerContext)context);
        CompartmentDecorator routeCompartmentDecorator = new CompartmentDecorator(((SplitterNode)router.getEntity()).getCompartment(), true);
        routeCompartmentDecorator.addLane(routeLane);
        this.pushContainer(routeLane);
        return this;
    }

    public AbstractPipelineBuilder<T> addConditionalRoute(String condition) {
        SplitterNode router = (SplitterNode)((SplitterDecorator)this.getCurrentContainer()).getEntity();
        IFlowTransformerContext context = this.createContext();
        context.getEntityStack().push(router);
        RouteDefinition routeDef = (RouteDefinition)this.getNestedDefinitionByType("http://www.mulesoft.org/schema/mule/core/when");
        Route route = MessageFlowFactory.createRoute((IFlowTransformerContext)context, (RouteDefinition)routeDef);
        route.setEntityId(UUID.randomUUID().toString());
        Compartment compartment = router.getCompartment();
        String routeName = this.createRouteName(router, compartment.getLanes().size());
        this.modelElements.put(routeName, (MessageFlowEntity)route);
        new CompartmentDecorator(compartment, true).addLane((CompartmentLane)route);
        PropertyCollectionMap routeProperties = new PropertyCollectionMap();
        routeProperties.addProperty(PROP_EXPRESSION, condition);
        route.setProperties(routeProperties.asPropertyCollection());
        this.pushContainer((CompartmentLane)route);
        this.setCurrentElement((MessageFlowEntity)route);
        return this;
    }

    private String createRouteName(SplitterNode routerEntity, int index) {
        return routerEntity.getName() + "[" + index + "]";
    }

    public AbstractPipelineBuilder<T> editRouteCondition(int routeNumber, String condition) {
        SplitterNode routerEntity = (SplitterNode)((SplitterDecorator)this.getCurrentContainer()).getEntity();
        String routeName = this.createRouteName(routerEntity, routeNumber);
        Route routeLane = (Route)this.modelElements.get(routeName);
        PropertyCollectionMap routeProperties = routeLane.getProperties().toPropertyCollectionMap();
        routeProperties.addProperty(PROP_EXPRESSION, condition);
        routeLane.setProperties(routeProperties.asPropertyCollection());
        return this;
    }

    protected EntityDecorator<?> getCurrentContainer() {
        return this.currentContainerStack.peek();
    }

    private CompartmentLaneDecorator<?> getContainerFor(String entityName) {
        return this.modelElementContainer.get(entityName);
    }

    protected NodeDefinition getDefinitionByType(String endpointType) {
        return MuleCorePlugin.getModuleManager().getDefinition(endpointType);
    }

    protected NestedDefinition getNestedDefinitionByType(String nestedId) {
        return MuleCorePlugin.getModuleManager().getNestedDefinition(nestedId);
    }

    public AbstractPipelineBuilder<T> addOtherwiseRoute() {
        SplitterDecorator router = (SplitterDecorator)this.getCurrentContainer();
        SplitterNode routerEntity = (SplitterNode)router.getEntity();
        IFlowTransformerContext context = this.createContext();
        context.getEntityStack().push(routerEntity);
        RouteDefinition definition = (RouteDefinition)this.getNestedDefinitionByType("http://www.mulesoft.org/schema/mule/core/choice-default");
        Route route = MessageFlowFactory.createRoute((IFlowTransformerContext)context, (RouteDefinition)definition);
        route.setEntityId(UUID.randomUUID().toString());
        CompartmentDecorator routeCompartmentDecorator = new CompartmentDecorator(((SplitterNode)router.getEntity()).getCompartment(), true);
        this.modelElements.put(((SplitterNode)router.getEntity()).getName() + "[" + routeCompartmentDecorator.getLanes().size() + "]", (MessageFlowEntity)route);
        routeCompartmentDecorator.addLane((CompartmentLane)route);
        this.pushContainer((CompartmentLane)route);
        this.setCurrentElement((MessageFlowEntity)route);
        return this;
    }

    public AbstractPipelineBuilder<T> addOnErrorContinue(String name) {
        return this.addSimpleContainer("http://www.mulesoft.org/schema/mule/core/on-error-continue", name);
    }

    public AbstractPipelineBuilder<T> addOnErrorPropagate(String name) {
        return this.addSimpleContainer("http://www.mulesoft.org/schema/mule/core/on-error-propagate", name);
    }

    public AbstractPipelineBuilder<T> addAsync(String name) {
        return this.addSimpleContainer("http://www.mulesoft.org/schema/mule/core/async", name);
    }

    public AbstractPipelineBuilder<T> addForeach(String name) {
        return this.addSimpleContainer("http://www.mulesoft.org/schema/mule/core/foreach", name);
    }

    public ContainerBuilder<AbstractPipelineBuilder<T>> addRequestReply(String name) {
        return this.addContainer("http://www.mulesoft.org/schema/mule/core/request-reply", name);
    }

    public ContainerBuilder<AbstractPipelineBuilder<T>> addTry(String name) {
        return this.addContainer("http://www.mulesoft.org/schema/mule/core/try", name);
    }

    public ContainerBuilder<AbstractPipelineBuilder<T>> addBatch(String name) {
        return this.addContainer("http://www.mulesoft.org/schema/mule/batch/job", name);
    }

    public AbstractPipelineBuilder<T> endBlock() {
        this.currentContainerStack.pop();
        return this;
    }

    public MessageFlowEntity getElement(String name) {
        return this.modelElements.get(name);
    }

    public Optional<MessageFlowEntity> getElementOpt(String name) {
        return Optional.fromNullable((Object)this.modelElements.get(name));
    }

    public Map<String, MessageFlowEntity> getElements() {
        return this.modelElements;
    }

    public AbstractPipelineBuilder<T> removeElement(String name) {
        MessageFlowEntity elementToRemove = this.getElement(name);
        if (elementToRemove == null) {
            throw new IllegalArgumentException("There is no element with name [" + name + "]");
        }
        CompartmentLaneDecorator<?> parent = this.getContainerFor(name);
        parent.removeEntity(elementToRemove);
        return this;
    }

    private EndpointNode createEndpointNode(EndpointDefinition definition, MessageExchangePattern pattern, EndpointDirection direction) {
        IFlowTransformerContext context = this.createContext();
        EndpointNode endpoint = MessageFlowFactory.createEndpointNode((IFlowTransformerContext)context, (EndpointDefinition)definition, (EndpointDirection)direction);
        endpoint.setDirection(direction);
        endpoint.setEntityId(UUID.randomUUID().toString());
        endpoint.setName(definition.getDocName());
        endpoint.setMessageExchangePattern(pattern);
        endpoint.setType(definition.getId());
        endpoint.setDefinition((NodeDefinition)definition);
        PropertyCollectionMap props = new PropertyCollectionMap(endpoint.getProperties());
        if (definition.isResponseParticipant()) {
            props.addProperty("response-participant", "true");
        }
        endpoint.setProperties(props.asPropertyCollection());
        return endpoint;
    }

    protected void addChild(CompartmentLaneDecorator<?> parent, MessageFlowEntity child) {
        if (this.after != null) {
            parent.addEntityAfter((IMessageFlowEntity)child, (IMessageFlowEntity)this.after);
            this.after = null;
        } else if (this.before != null) {
            parent.addEntityBefore((IMessageFlowEntity)child, (IMessageFlowEntity)this.before);
            this.before = null;
        } else {
            parent.addEntity((IMessageFlowEntity)child);
        }
    }

    public AbstractPipelineBuilder<T> before(String entityName) {
        this.before = this.getElement(entityName);
        return this;
    }

    public AbstractPipelineBuilder<T> after(String entityName) {
        this.after = this.getElement(entityName);
        return this;
    }

    public AbstractPipelineBuilder<T> addSoap(String name) {
        return this.addPattern("http://www.mulesoft.org/schema/mule/cxf/soapComponent", name);
    }

    public AbstractPipelineBuilder<T> addPattern(String type, String name) {
        IFlowTransformerContext context = this.createContext();
        PatternNode pattern = MessageFlowFactory.createPatternNode((IFlowTransformerContext)context, (NodeDefinition)this.getDefinitionByType(type));
        pattern.setName(name);
        this.addElement(name, (MessageFlowEntity)pattern);
        return this;
    }

    public AbstractPipelineBuilder<T> addEndpoint(String endpointType, String name, MessageExchangePattern pattern, EndpointDirection direction) {
        EndpointDefinition nodeDef = (EndpointDefinition)this.getDefinitionByType(endpointType);
        EndpointNode createEndpointNode = this.createEndpointNode(nodeDef, pattern, direction);
        createEndpointNode.setName(name);
        this.addElement(name, (MessageFlowEntity)createEndpointNode);
        return this;
    }

    protected void addElement(String name, MessageFlowEntity element) {
        CompartmentLaneDecorator parent = (CompartmentLaneDecorator)this.getCurrentContainer();
        this.addChild(parent, element);
        this.registerElement(name, element, parent);
        this.setCurrentElement(element);
    }

    protected void registerElement(String name, MessageFlowEntity element, CompartmentLaneDecorator<?> parent) {
        String originalName = name;
        int i = 0;
        while (this.modelElements.containsKey(name)) {
            name = originalName + i;
            ++i;
        }
        this.modelElements.put((String)name, element);
        this.modelElementContainer.put((String)name, parent);
    }

    public AbstractPipelineBuilder<T> addTransactional(String name) {
        this.addSimpleContainer("http://www.mulesoft.org/schema/mule/ee/core/transactional-scope", name);
        return this;
    }

    public AbstractPipelineBuilder<T> addSimpleContainer(String type, String name) {
        ContainerDefinition definition = (ContainerDefinition)MuleCorePlugin.getModuleManager().getDefinition(type);
        Container newContainer = MessageFlowFactory.createContainer((IFlowTransformerContext)this.createContext(), null, (ContainerDefinition)definition);
        newContainer.setName(name);
        this.addElement(name, (MessageFlowEntity)newContainer);
        CompartmentLane nestedContainer = (CompartmentLane)newContainer.getLanes().get(0);
        this.pushContainer(nestedContainer);
        return this;
    }

    public ContainerBuilder<AbstractPipelineBuilder<T>> addContainer(String type, String name) {
        ContainerDefinition containerDefinition = (ContainerDefinition)this.getDefinitionByType(type);
        Container createContainer = MessageFlowFactory.createContainer((IFlowTransformerContext)this.createContext(), null, (ContainerDefinition)containerDefinition);
        createContainer.setName(name);
        this.addElement(name, (MessageFlowEntity)createContainer);
        return new ContainerBuilder<AbstractPipelineBuilder<T>>(this, createContainer);
    }

    public AbstractPipelineBuilder<T> addScheduler(String name) {
        return this.addEndpoint("http://www.mulesoft.org/schema/mule/core/scheduler", name, MessageExchangePattern.ONE_WAY, EndpointDirection.INBOUND);
    }

    public AbstractPipelineBuilder<T> addCache(String name) {
        return this.addSimpleContainer("http://www.mulesoft.org/schema/mule/ee/core/cache", name);
    }

    public AbstractPipelineBuilder<T> addFlowRef(String name) {
        return this.addPattern("http://www.mulesoft.org/schema/mule/core/flow-ref", name);
    }

    public AbstractPipelineBuilder<T> addBatchExcecute(String name) {
        return this.addPattern("http://www.mulesoft.org/schema/mule/batch/execute", name);
    }

    public AbstractPipelineBuilder<T> addBatchStep(String name) {
        return this.addSimpleContainer("http://www.mulesoft.org/schema/mule/batch/step", name);
    }

    @Override
    public void setProperties(PropertyCollection properties) {
        MessageFlowEntity currentElement = this.getCurrentElement();
        AbstractPipelineBuilder.populateSubPropertiesElements(properties, (IMessageFlowNode)this.getCurrentElement());
        Class<?> elementClass = currentElement.getClass();
        try {
            Method setPropretiesMethod = elementClass.getMethod("setProperties", PropertyCollection.class);
            setPropretiesMethod.invoke((Object)currentElement, properties);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Set properties is not supported for " + String.valueOf(currentElement.getClass()), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Set properties is not supported for " + String.valueOf(currentElement.getClass()), e);
        }
    }

    public static void populateSubPropertiesElements(PropertyCollection properties, IMessageFlowNode currentElement) {
        List propertyCollections = properties.getPropertyCollections();
        for (PropertyCollection propertyCollection : propertyCollections) {
            if (propertyCollection.getElement() == null) {
                String childDefinitionId = PropertiesUtils.getNodeDefinitionId((String)propertyCollection.getName());
                IXmlOrder service = (IXmlOrder)currentElement.getDefinition().getService(IXmlOrder.class);
                propertyCollection.setElement(MessageFlowUtils.createElement((IMessageFlowNode)currentElement, (PropertyCollection)propertyCollection, (int)service.getXmlOrder(childDefinitionId)));
                AbstractPipelineBuilder.populateSubPropertiesElements(propertyCollection, currentElement);
                continue;
            }
            AbstractPipelineBuilder.populateSubPropertiesElements(propertyCollection, currentElement);
        }
    }

    public T end() {
        return null;
    }

    public abstract MessageFlowEntity getModel();

    public AbstractPipelineBuilder<T> addUnknown(String name) {
        this.addElement(name, (MessageFlowEntity)MessageFlowFactory.createUnknownNode((IFlowTransformerContext)this.createContext(), (String)name));
        return this;
    }

    public MessageFlowEntity getAfter() {
        return this.after;
    }

    public void setAfter(MessageFlowEntity after) {
        this.after = after;
    }

    public MessageFlowEntity getBefore() {
        return this.before;
    }

    public void setBefore(MessageFlowEntity before) {
        this.before = before;
    }

    public boolean contains(MessageFlowEntity entity) {
        return this.modelElements.containsValue(entity);
    }

    private IFlowTransformerContext createContext() {
        IFlowTransformerContext context = NewFlowTransformerContext.create((IMuleProject)MuleCorePlugin.getDesignContext().getMuleProject(), (MuleConfiguration)this.muleConfigurationProvider.getMuleConfiguration());
        return context;
    }
}

