/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.contextualhelp;

import j2html.TagCreator;
import j2html.attributes.Attr;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.tooling.model.module.NodeDefinition;
import org.mule.tooling.ui.modules.core.contextualhelp.IDocumentationDescriptorProvider;
import org.mule.tooling.ui.modules.core.contextualhelp.LinkDescriptor;
import org.mule.tooling.ui.widgets.theme.StudioDarkTheme;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class HelpHtmlCreator {
    private static final String DESCRIPTION_ID = "#description";
    private static final String MULE_4_DOCUMENTATION = "Mule 4 documentation";
    private static final String READ_MORE_INFO = "Read more about configuring connectors and building flows in the ";
    private static final String SEE_ALSO = "See also:";
    private static final String STYLE = "body {font-family: -apple-system,BlinkMacSystemFont,\"Segoe UI\",Roboto,Oxygen-Sans,Ubuntu,Cantarell,\"Helvetica Neue\",sans-serif;font-size: 12}" + System.lineSeparator();
    private static final String DARK_STYLE = "body { background-color:#2f2f2f; color:#dfdfdf;font-family: -apple-system,BlinkMacSystemFont,\"Segoe UI\",Roboto,Oxygen-Sans,Ubuntu,Cantarell,\"Helvetica Neue\",sans-serif;font-size: 12} a:link {color: #007fd4;}  a:visited {color: #c700c7;} a:active {color: #FF0000;}" + System.lineSeparator();
    private NodeDefinition definition;
    private IDocumentationDescriptorProvider documentationDescriptorProvider;

    public HelpHtmlCreator(NodeDefinition definition, IDocumentationDescriptorProvider linkProvider) {
        this.definition = definition;
        this.documentationDescriptorProvider = linkProvider;
    }

    public String getHelpHtml() {
        String description = this.definition.getDescription();
        return TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.style((DomContent[])new DomContent[]{TagCreator.rawHtml((String)(ThemeUtils.getCurrentTheme() instanceof StudioDarkTheme ? DARK_STYLE : STYLE))})}), TagCreator.body((DomContent[])new DomContent[]{TagCreator.div((Attr.ShortForm)TagCreator.attrs((String)DESCRIPTION_ID), (DomContent[])new DomContent[]{TagCreator.rawHtml((String)description)}), this.getLinks(this.definition.getId()).isEmpty() ? this.createNoDocumentationSection() : this.createLinksSection()})}).render();
    }

    private ContainerTag createLinksSection() {
        return TagCreator.div((DomContent[])new DomContent[]{TagCreator.h3((String)SEE_ALSO), TagCreator.div((DomContent[])new DomContent[]{TagCreator.ul((DomContent[])new DomContent[]{TagCreator.each(this.getLinks(this.definition.getId()), link -> TagCreator.li((DomContent[])new DomContent[]{TagCreator.a((String)(link.getTitle() == null ? link.getLink() : link.getTitle())).withHref(link.getLink())}))})})});
    }

    private List<LinkDescriptor> getLinks(String nodeDefinitionId) {
        return this.documentationDescriptorProvider.getAllDocumentDescriptorsFor(nodeDefinitionId).stream().flatMap(documentationDescriptor -> documentationDescriptor.getLinks().stream()).collect(Collectors.toList());
    }

    private ContainerTag createNoDocumentationSection() {
        return TagCreator.div((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{TagCreator.text((String)READ_MORE_INFO), TagCreator.a((String)MULE_4_DOCUMENTATION).withHref("https://docs.mulesoft.com/mule-runtime/latest/")})});
    }
}

