/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.contextualhelp;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.tooling.ui.modules.core.contextualhelp.DocumentationDescriptor;
import org.mule.tooling.ui.modules.core.contextualhelp.DocumentationProviderExtension;
import org.mule.tooling.ui.modules.core.contextualhelp.IDocumentationDescriptorProvider;
import org.mule.tooling.ui.modules.core.contextualhelp.IDocumentationProvider;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public enum DocumentationProviderExtensionManager implements IDocumentationDescriptorProvider
{
    INSTANCE;

    private List<IDocumentationProvider> documentationProviders;

    private DocumentationProviderExtensionManager() {
        this.initialize();
    }

    private void initialize() {
        IExtensionPointReader reader = IExtensionPointReader.create(DocumentationProviderExtension.class);
        List extensions = reader.readAll();
        this.documentationProviders = new ArrayList<IDocumentationProvider>(extensions.size());
        for (DocumentationProviderExtension documentationProviderExtension : extensions) {
            IDocumentationProvider documentationProvider = documentationProviderExtension.getDocumentationProvider();
            this.documentationProviders.add(documentationProvider);
        }
    }

    @Override
    public List<DocumentationDescriptor> getAllDocumentDescriptorsFor(String nodeDefinitionId) {
        return this.documentationProviders.stream().filter(provider -> provider != null && provider.getDocumentationDescriptor(nodeDefinitionId) != null).map(provider -> provider.getDocumentationDescriptor(nodeDefinitionId)).collect(Collectors.toList());
    }
}

