/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.contextualhelp;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.browser.BrowserProxy;
import org.mule.tooling.browser.IBrowser;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.icons.ImagesManager;
import org.mule.tooling.messageflow.module.CustomPageComposite;
import org.mule.tooling.messageflow.module.ICustomPage;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.contextualhelp.DocumentationProviderExtensionManager;
import org.mule.tooling.ui.modules.core.contextualhelp.HelpHtmlCreator;
import org.mule.tooling.ui.widgets.IMessageLogger;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class ContextHelpCustomPage
implements ICustomPage {
    private static int pagePosition = 100;
    private CustomPageComposite container;
    private ScrolledComposite scrolledComposite;
    private IMessageFlowNode node;
    private Composite wrapperContainer;

    public CustomPageComposite createControl(Composite parent) {
        this.container = new CustomPageComposite(parent, 0);
        ThemeUtils.setCssId((Object)this.container, (String)"helpPageContainer");
        this.container.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ContextHelpCustomPage.this.scrolledComposite == null) {
                    ContextHelpCustomPage.this.createContent();
                }
            }
        });
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo((Composite)this.container);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.container);
        this.container.setBackground(Display.getDefault().getSystemColor(1));
        this.container.setBackgroundMode(2);
        return this.container;
    }

    private void createContent() {
        Composite containerGroup = new Composite((Composite)this.container, 64);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(containerGroup);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)containerGroup);
        this.scrolledComposite = new ScrolledComposite(containerGroup, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)this.scrolledComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.scrolledComposite);
        this.wrapperContainer = new Composite((Composite)this.scrolledComposite, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(this.wrapperContainer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.wrapperContainer);
        this.wrapperContainer.setBackgroundMode(2);
        this.scrolledComposite.setContent((Control)this.wrapperContainer);
        this.scrolledComposite.addListener(11, event -> this.relayout(this.scrolledComposite, this.wrapperContainer));
        this.createDocumentationComponent(this.wrapperContainer);
        this.container.layout(true, true);
    }

    private void relayout(ScrolledComposite scrolledComposite, Composite contributed) {
        Point contributedCompositeSize = contributed.computeSize(-1, -1);
        scrolledComposite.setMinSize(-1, contributedCompositeSize.y + 50);
        scrolledComposite.layout(true, true);
    }

    private void createDocumentationComponent(Composite parent) {
        CLabel elementTitleLabel = new CLabel(parent, 0);
        String name = this.node.getDefinition().getName();
        elementTitleLabel.setText(name);
        Font headerFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.headerfont");
        elementTitleLabel.setFont(headerFont);
        final String id = this.node.getDefinition().getId();
        Image elementIcon = ImagesManager.getInstance().getImage(id);
        elementTitleLabel.setImage(elementIcon);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)elementTitleLabel);
        IBrowser documentationComponentBrowser = BrowserProxy.createBrowser((Composite)parent);
        documentationComponentBrowser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String location = event.location;
                try {
                    if (!location.equals("about:blank") && !location.startsWith("data:text")) {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(location));
                        AnalyticsRecordsFactory.single((String)Events.OPEN_DOCUMENTATION_LINK, (String[])new String[]{"nodeDefinitionId", id, "openedLink", location}).track();
                        event.doit = false;
                    }
                }
                catch (MalformedURLException | PartInitException e) {
                    MuleCorePlugin.logError((String)("Unable to open url " + location), (Throwable)e);
                }
            }

            public void changed(LocationEvent event) {
            }
        });
        documentationComponentBrowser.setText(new HelpHtmlCreator(this.node.getDefinition(), DocumentationProviderExtensionManager.INSTANCE).getHelpHtml());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)documentationComponentBrowser.getComposite());
    }

    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        this.node = node;
        if (this.wrapperContainer != null) {
            this.createDocumentationComponent(this.wrapperContainer);
        }
    }

    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
    }

    public String getTitle() {
        return "Help";
    }

    public String getDescription() {
        return "Contextual Help Documentation";
    }

    public boolean accepts(IMessageFlowNode node) {
        return true;
    }

    public void setMessageLogger(IMessageLogger messageLogger) {
    }

    public Integer getPosition() {
        return pagePosition;
    }
}

