/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.container;

import java.util.List;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.container.BaseContainerBehavior;
import org.mule.tooling.core.builder.messageflow.MuleToFlowTransformer;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.GraphicalContainerDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;

public class TryContainerBehaviour
extends BaseContainerBehavior {
    private static final int ERROR_HANDLER_NESTED_CONTAINER_NUMBER = 1;
    private static final int BLOCK_GRAPHICAL_CONTAINER_NUMBER = 0;
    private static final String ERROR_HANDLING_REF = "ref";
    private static final String ERROR_HANDLER_TEXT_REF = "Error handler reference: ";

    public void handleContainerElements(List<IElementWrapper> elements, Container container, ContainerDefinition containerDefinition, MuleConfiguration muleConfiguration, String runtimeVersion, MuleToFlowTransformer muleToFlowTransformer) {
        NestedContainer transactionalContainer = this.getTryContainer(container, containerDefinition);
        NestedContainer exceptionStratContainer = this.getErrorHandlerContainer(container, containerDefinition);
        for (IElementWrapper element : elements) {
            MessageFlowEntity populatedNode = this.getPopulatedNode(muleToFlowTransformer, element, muleConfiguration, runtimeVersion);
            if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)populatedNode)) {
                this.addToContainer(element, exceptionStratContainer, muleToFlowTransformer, runtimeVersion, muleConfiguration);
                continue;
            }
            this.addToContainer(element, transactionalContainer, muleToFlowTransformer, runtimeVersion, muleConfiguration);
        }
    }

    private MessageFlowEntity getPopulatedNode(MuleToFlowTransformer muleToFlowTransformer, IElementWrapper element, MuleConfiguration muleConfiguration, String runtimeVersion) {
        NodeDefinition def = MuleCorePlugin.getModuleManager().getDefinitionForElement(element, runtimeVersion);
        MessageFlowEntity entity = muleToFlowTransformer.getPopulatedNode(element, muleConfiguration, def, runtimeVersion);
        return entity;
    }

    private void addToContainer(IElementWrapper element, NestedContainer container, MuleToFlowTransformer muleToFlowTransformer, String runtimeVersion, MuleConfiguration muleConfiguration) {
        NodeDefinition def = MuleCorePlugin.getModuleManager().getDefinitionForElement(element, runtimeVersion);
        MessageFlowEntity entity = muleToFlowTransformer.getPopulatedNode(element, muleConfiguration, def, runtimeVersion);
        container.getCompartmentLaneEntries().add(entity);
    }

    private NestedContainer getTryContainer(Container container, ContainerDefinition containerDefinition) {
        List graphicalContainerDefinitions = containerDefinition.getGraphicalContainerDefinitions();
        GraphicalContainerDefinition outboundContainerDef = (GraphicalContainerDefinition)graphicalContainerDefinitions.get(0);
        NestedContainer outboundContainer = container.getNestedContainer(outboundContainerDef.getId());
        return outboundContainer;
    }

    private NestedContainer getErrorHandlerContainer(Container container, ContainerDefinition containerDefinition) {
        List nestedContainerDefinitions = containerDefinition.getNestedContainerDefinitions();
        NestedContainerDefinition errorContainerDef = (NestedContainerDefinition)nestedContainerDefinitions.get(1);
        NestedContainer errorHandlerContainer = container.getNestedContainer(errorContainerDef.getId());
        if (errorHandlerContainer.getElement().getChildElements().isEmpty()) {
            IAttributeListWrapper attributes = errorHandlerContainer.getElement().getAttributes();
            for (IAttributeWrapper attribute : attributes) {
                if (!attribute.getName().equals(ERROR_HANDLING_REF)) continue;
                errorHandlerContainer.setName(ERROR_HANDLER_TEXT_REF + attribute.getText());
            }
        }
        return errorHandlerContainer;
    }
}

