/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.container;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.builder.container.BaseContainerBehavior;
import org.mule.tooling.core.builder.messageflow.MuleToFlowTransformer;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.GraphicalContainerDefinition;

public class TransactionalContainerBehavior
extends BaseContainerBehavior {
    private static final int TRANSACTIONAL_ES_NESTED_CONTAINER_NUMBER = 1;
    private static final int TRANSACTION_NESTED_CONTAINER_NUMBER = 0;

    public void handleContainerElements(List<IElementWrapper> elements, Container container, ContainerDefinition containerDefinition, MuleConfiguration muleConfiguration, String runtimeVersion, MuleToFlowTransformer muleToFlowTransformer) {
        NestedContainer processContainer = this.getTransactionalContainer(container, containerDefinition);
        NestedContainer exceptionContainer = this.getExceptionStrategyContainer(container, containerDefinition);
        ArrayList<MessageFlowEntity> processEntities = new ArrayList<MessageFlowEntity>();
        ArrayList<MessageFlowEntity> exceptionEntities = new ArrayList<MessageFlowEntity>();
        for (IElementWrapper element : elements) {
            MessageFlowEntity entity = this.getEntity(element, muleToFlowTransformer, muleConfiguration, runtimeVersion);
            if (!MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)entity) && exceptionEntities.isEmpty()) {
                processEntities.add(entity);
                continue;
            }
            exceptionEntities.add(entity);
        }
        this.addEntitiesToNestedContainer(processEntities, container, processContainer);
        this.addEntitiesToNestedContainer(exceptionEntities, container, exceptionContainer);
    }

    private NestedContainer getTransactionalContainer(Container container, ContainerDefinition containerDefinition) {
        List graphicalContainerDefinitions = containerDefinition.getGraphicalContainerDefinitions();
        GraphicalContainerDefinition outboundContainerDef = (GraphicalContainerDefinition)graphicalContainerDefinitions.get(0);
        return container.getNestedContainer(outboundContainerDef.getId());
    }

    private NestedContainer getExceptionStrategyContainer(Container container, ContainerDefinition containerDefinition) {
        List graphicalContainerDefinitions = containerDefinition.getGraphicalContainerDefinitions();
        GraphicalContainerDefinition outboundContainerDef = (GraphicalContainerDefinition)graphicalContainerDefinitions.get(1);
        return container.getNestedContainer(outboundContainerDef.getId());
    }
}

