/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.container;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.builder.container.BaseContainerBehavior;
import org.mule.tooling.core.builder.messageflow.MuleToFlowTransformer;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.EndpointDirection;
import org.mule.tooling.model.messageflow.EndpointNode;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.GraphicalContainerDefinition;

public class RequestReplyContainerBehavior
extends BaseContainerBehavior {
    public void handleContainerElements(List<IElementWrapper> elements, Container container, ContainerDefinition containerDefinition, MuleConfiguration muleConfiguration, String runtimeVersion, MuleToFlowTransformer muleToFlowTransformer) {
        int numberOfChildren = elements.size();
        if (numberOfChildren > 0) {
            NestedContainer outboundContainer = this.getOutboundContainer(container, containerDefinition);
            NestedContainer inboundContainer = this.getInboundContainer(container, containerDefinition);
            ArrayList<MessageFlowEntity> inboundEntities = new ArrayList<MessageFlowEntity>();
            ArrayList<MessageFlowEntity> outboundEntities = new ArrayList<MessageFlowEntity>();
            if (numberOfChildren == 1) {
                IElementWrapper firstElement = elements.get(0);
                MessageFlowEntity entity = this.getEntity(firstElement, muleToFlowTransformer, muleConfiguration, runtimeVersion);
                InboundOrOutboundVisitor visitor = new InboundOrOutboundVisitor();
                entity.accept((MessageFlowEntityVisitor)visitor);
                if (visitor.isInbound()) {
                    inboundEntities.add(entity);
                } else {
                    outboundEntities.add(entity);
                }
            } else {
                int i = 0;
                while (i < elements.size()) {
                    MessageFlowEntity entity = this.getEntity(elements.get(i), muleToFlowTransformer, muleConfiguration, runtimeVersion);
                    if (i == 0) {
                        outboundEntities.add(entity);
                    } else {
                        inboundEntities.add(entity);
                    }
                    ++i;
                }
            }
            this.addEntitiesToNestedContainer(outboundEntities, container, outboundContainer);
            this.addEntitiesToNestedContainer(inboundEntities, container, inboundContainer);
        }
    }

    private NestedContainer getInboundContainer(Container container, ContainerDefinition containerDefinition) {
        List graphicalContainerDefinitions = containerDefinition.getGraphicalContainerDefinitions();
        GraphicalContainerDefinition inboundContainerDef = (GraphicalContainerDefinition)graphicalContainerDefinitions.get(1);
        return container.getNestedContainer(inboundContainerDef.getId());
    }

    private NestedContainer getOutboundContainer(Container container, ContainerDefinition containerDefinition) {
        List graphicalContainerDefinitions = containerDefinition.getGraphicalContainerDefinitions();
        GraphicalContainerDefinition outboundContainerDef = (GraphicalContainerDefinition)graphicalContainerDefinitions.get(0);
        return container.getNestedContainer(outboundContainerDef.getId());
    }

    private static class InboundOrOutboundVisitor
    extends MessageFlowEntityVisitorAdapter {
        private boolean inbound;

        private InboundOrOutboundVisitor() {
        }

        public boolean isInbound() {
            return this.inbound;
        }

        public void visitEndpointNode(EndpointNode endpointNode) {
            this.inbound = endpointNode.getDirection().equals((Object)EndpointDirection.INBOUND);
        }
    }
}

