/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.container;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.builder.container.BaseContainerBehavior;
import org.mule.tooling.core.builder.messageflow.MuleToFlowTransformer;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.GraphicalContainerDefinition;
import org.mule.tooling.model.module.NestedContainerDefinition;

public class FlowContainerBehavior
extends BaseContainerBehavior {
    private static final int SOURCE_NESTED_CONTAINER_INDEX = 0;
    private static final int PROCESS_NESTED_CONTAINER_INDEX = 1;
    private static final int ERROR_HANDLING_NESTED_CONTAINER_INDEX = 2;
    private static final String ERROR_HANDLING_REF = "ref";
    private static final String ERROR_HANDLER_TEXT_REF = "Error handler reference: ";

    public void handleContainerElements(List<IElementWrapper> elements, Container container, ContainerDefinition containerDefinition, MuleConfiguration muleConfiguration, String runtimeVersion, MuleToFlowTransformer muleToFlowTransformer) {
        NestedContainer inputContainer = this.getSourceContainer(container, containerDefinition);
        NestedContainer processContainer = this.getProcessorsContainer(container, containerDefinition);
        NestedContainer exceptionContainer = this.getExceptionStrategyContainer(container, containerDefinition);
        ArrayList<MessageFlowEntity> inputEntities = new ArrayList<MessageFlowEntity>();
        ArrayList<MessageFlowEntity> processEntities = new ArrayList<MessageFlowEntity>();
        ArrayList<MessageFlowEntity> exceptionEntities = new ArrayList<MessageFlowEntity>();
        for (IElementWrapper element : elements) {
            MessageFlowEntity entity = this.getEntity(element, muleToFlowTransformer, muleConfiguration, runtimeVersion);
            if (ModelUtils.isMessageSource((IMessageFlowEntity)entity)) {
                if (inputEntities.isEmpty()) {
                    inputEntities.add(entity);
                    continue;
                }
                if (exceptionEntities.isEmpty()) {
                    processEntities.add(entity);
                    continue;
                }
                exceptionEntities.add(entity);
                continue;
            }
            if (MessageFlowUtils.isExceptionStrategy((IMessageFlowEntity)entity)) {
                exceptionEntities.add(entity);
                continue;
            }
            if (!exceptionEntities.isEmpty()) {
                exceptionEntities.add(entity);
                continue;
            }
            processEntities.add(entity);
        }
        this.addEntitiesToNestedContainer(inputEntities, container, inputContainer);
        this.addEntitiesToNestedContainer(processEntities, container, processContainer);
        this.addEntitiesToNestedContainer(exceptionEntities, container, exceptionContainer);
    }

    private NestedContainer getSourceContainer(Container container, ContainerDefinition containerDefinition) {
        List graphicalContainerDefinitions = containerDefinition.getGraphicalContainerDefinitions();
        GraphicalContainerDefinition inboundContainerDef = (GraphicalContainerDefinition)graphicalContainerDefinitions.get(0);
        return container.getNestedContainer(inboundContainerDef.getId());
    }

    private NestedContainer getProcessorsContainer(Container container, ContainerDefinition containerDefinition) {
        List graphicalContainerDefinitions = containerDefinition.getGraphicalContainerDefinitions();
        GraphicalContainerDefinition outboundContainerDef = (GraphicalContainerDefinition)graphicalContainerDefinitions.get(1);
        return container.getNestedContainer(outboundContainerDef.getId());
    }

    private NestedContainer getExceptionStrategyContainer(Container container, ContainerDefinition containerDefinition) {
        List graphicalContainerDefinitions = containerDefinition.getNestedContainerDefinitions();
        NestedContainerDefinition outboundContainerDef = (NestedContainerDefinition)graphicalContainerDefinitions.get(2);
        NestedContainer outboundContainer = container.getNestedContainer(outboundContainerDef.getId());
        if (outboundContainer.getElement().getChildElements().isEmpty()) {
            IAttributeListWrapper attributes = outboundContainer.getElement().getAttributes();
            for (IAttributeWrapper attribute : attributes) {
                if (!attribute.getName().equals(ERROR_HANDLING_REF)) continue;
                outboundContainer.setName(ERROR_HANDLER_TEXT_REF + attribute.getText());
            }
        }
        return outboundContainer;
    }
}

