/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.container;

import java.util.List;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.container.BaseContainerBehavior;
import org.mule.tooling.core.builder.messageflow.MuleToFlowTransformer;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MessageFlowEntity;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.module.ContainerDefinition;
import org.mule.tooling.model.module.GraphicalContainerDefinition;
import org.mule.tooling.model.module.NodeDefinition;

public class BatchStepContainerBehaviour
extends BaseContainerBehavior {
    private static final int BATCH_AGGREGATOR_GRAPHICAL_CONTAINER = 1;
    private static final int BATCH_STEP_PROCESSORS_GRAPHICAL_CONTAINER = 0;

    public void handleContainerElements(List<IElementWrapper> elements, Container container, ContainerDefinition containerDefinition, MuleConfiguration muleConfiguration, String runtimeVersion, MuleToFlowTransformer muleToFlowTransformer) {
        NestedContainer batchProcessors = this.getBatchStepProcessorsContainer(container, containerDefinition);
        NestedContainer batchAggregator = this.getBatchAggregatorProcessorsContainer(container, containerDefinition);
        for (IElementWrapper element : elements) {
            MessageFlowEntity populatedNode = this.getPopulatedNode(muleToFlowTransformer, element, muleConfiguration, runtimeVersion);
            if (MessageFlowUtils.isBatchAggregator((MessageFlowEntity)populatedNode)) {
                this.addToContainer(element, batchAggregator, muleToFlowTransformer, runtimeVersion, muleConfiguration);
                continue;
            }
            this.addToContainer(element, batchProcessors, muleToFlowTransformer, runtimeVersion, muleConfiguration);
        }
    }

    private MessageFlowEntity getPopulatedNode(MuleToFlowTransformer muleToFlowTransformer, IElementWrapper element, MuleConfiguration muleConfiguration, String runtimeVersion) {
        NodeDefinition def = MuleCorePlugin.getModuleManager().getDefinitionForElement(element, runtimeVersion);
        MessageFlowEntity entity = muleToFlowTransformer.getPopulatedNode(element, muleConfiguration, def, runtimeVersion);
        return entity;
    }

    private void addToContainer(IElementWrapper element, NestedContainer container, MuleToFlowTransformer muleToFlowTransformer, String runtimeVersion, MuleConfiguration muleConfiguration) {
        NodeDefinition def = MuleCorePlugin.getModuleManager().getDefinitionForElement(element, runtimeVersion);
        MessageFlowEntity entity = muleToFlowTransformer.getPopulatedNode(element, muleConfiguration, def, runtimeVersion);
        container.getCompartmentLaneEntries().add(entity);
    }

    private NestedContainer getBatchStepProcessorsContainer(Container container, ContainerDefinition containerDefinition) {
        return this.getNestedContainer(container, containerDefinition, 0);
    }

    private NestedContainer getBatchAggregatorProcessorsContainer(Container container, ContainerDefinition containerDefinition) {
        return this.getNestedContainer(container, containerDefinition, 1);
    }

    private NestedContainer getNestedContainer(Container container, ContainerDefinition containerDefinition, int batchStepProcessorsGraphicalContainer) {
        List graphicalContainerDefinitions = containerDefinition.getGraphicalContainerDefinitions();
        GraphicalContainerDefinition outboundContainerDef = (GraphicalContainerDefinition)graphicalContainerDefinitions.get(batchStepProcessorsGraphicalContainer);
        NestedContainer outboundContainer = container.getNestedContainer(outboundContainerDef.getId());
        return outboundContainer;
    }
}

