/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.command;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.modules.core.metadata.management.MetadataManagementDialog;

public class OpenMetadataManagement
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection selection = window.getActivePage().getSelection();
        try {
            IMuleProject muleProjectForSelection = CoreUtils.getMuleProjectForSelection((IStructuredSelection)((IStructuredSelection)selection));
            if (muleProjectForSelection != null) {
                MetadataManagementDialog metadataManagementDialog = new MetadataManagementDialog(window.getShell(), muleProjectForSelection);
                metadataManagementDialog.open();
            } else {
                MessageDialog.openInformation((Shell)window.getShell(), (String)"Mule Project not available", (String)"The Mule Project is not available using the current selection. Select the root of the project and try again.");
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)"Cannot open the Metadata Types Management dialog.", (Throwable)e);
            MessageDialog.openError((Shell)window.getShell(), (String)"Problem opening the Metadata Types Manager", (String)"Cannot open the Metadata Types Management dialog, please check the exception in the Error Log and report this issue.");
        }
        return Status.OK_STATUS;
    }
}

