/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.xpath.ast;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.IXPathNodeVisitor;
import org.mule.tooling.utils.ListHelper;

public abstract class XPathNode {
    private List<XPathNode> children = new ArrayList<XPathNode>();
    private XPathNode parent;

    public XPathNode addChild(XPathNode node) {
        this.children.add(node);
        node.parent = this;
        return this;
    }

    public List<XPathNode> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Optional<XPathNode> getLeft() {
        return ListHelper.get(this.getChildren(), (int)0);
    }

    public Optional<XPathNode> getRight() {
        return ListHelper.get(this.getChildren(), (int)1);
    }

    public void setParent(XPathNode parent) {
        this.parent = parent;
    }

    public void removeChild(XPathNode node) {
        this.children.remove(node);
        node.parent = null;
    }

    public XPathNode getParent() {
        return this.parent;
    }

    public XPathNode getRoot() {
        return this.parent == null ? this : this.parent.getRoot();
    }

    public abstract int getPrecedence();

    public XPathNode getLastChild() {
        return this.getChildren().isEmpty() ? null : this.getChildren().get(this.getChildren().size() - 1);
    }

    public String toString() {
        return this.getClass().getSimpleName() + (String)(this.getChildren().isEmpty() ? "" : " [\n" + String.valueOf(this.children) + "\n]");
    }

    public abstract void accept(IXPathNodeVisitor var1);

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XPathNode other = (XPathNode)obj;
        return !(this.children == null ? other.children != null : !this.children.equals(other.children));
    }
}

