/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.xpath.ast;

import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.IXPathNodeVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathNode;

public class XPathIdentifierNode
extends XPathNode {
    private static final String NAME_SPACE_SEPARATOR = ":";
    private String identifier;

    public XPathIdentifierNode(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getLocalPart() {
        return this.identifier.contains(NAME_SPACE_SEPARATOR) ? this.identifier.substring(this.identifier.indexOf(NAME_SPACE_SEPARATOR) + 1) : this.identifier;
    }

    public String getPrefix() {
        return this.identifier.contains(NAME_SPACE_SEPARATOR) ? this.identifier.substring(0, this.identifier.indexOf(NAME_SPACE_SEPARATOR)) : null;
    }

    @Override
    public int getPrecedence() {
        return 1000;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XPathIdentifierNode other = (XPathIdentifierNode)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }

    @Override
    public String toString() {
        return "XPathIdentifierNode[" + this.identifier + "]";
    }

    @Override
    public void accept(IXPathNodeVisitor visitor) {
        visitor.acceptIdentifier(this);
    }
}

