/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.xpath.ast;

import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.IXPathNodeVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathIdentifierNode;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathNode;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathStatementNode;

public class XPathFunctionNode
extends XPathNode {
    private XPathStatementNode arguments;
    private XPathIdentifierNode name;

    public XPathFunctionNode(XPathIdentifierNode name, XPathStatementNode arguments) {
        this.name = name;
        this.arguments = arguments;
        name.setParent(this);
        arguments.setParent(this);
    }

    public XPathFunctionNode(XPathIdentifierNode name) {
        this(name, new XPathStatementNode());
    }

    @Override
    public XPathFunctionNode addChild(XPathNode node) {
        super.addChild(node);
        return this;
    }

    public XPathIdentifierNode getName() {
        return this.name;
    }

    @Override
    public int getPrecedence() {
        return 1000;
    }

    public XPathStatementNode getArguments() {
        return this.arguments;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XPathFunctionNode other = (XPathFunctionNode)obj;
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public String toString() {
        return "XPathFunctionNode " + this.name.getIdentifier() + "[" + String.valueOf(this.arguments) + "]";
    }

    @Override
    public void accept(IXPathNodeVisitor visitor) {
        visitor.acceptFunction(this);
    }
}

