/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.xpath;

import java.util.ArrayList;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.DecimalNumberRule;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.OperatorRule;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathBracket;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathBracketRule;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathBracketToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathIdentifierToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathNumberToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathOperator;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathOperatorToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathSelector;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathSelectorToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathStringToken;
import org.mule.tooling.ui.widgets.util.ThemeUtils;

public class XPathScanner
extends RuleBasedScanner {
    public static final Color STRING_COLOR = new Color(ThemeUtils.getCurrentTheme().getDFLStringColor());
    public static final Color COMMENT_COLOR = new Color(ThemeUtils.getCurrentTheme().getDFLCommentColor());
    public static final Color KEYWORD_COLOR = new Color(ThemeUtils.getCurrentTheme().getDFLKeywordColor());
    public static final Color NUMBER_COLOR = new Color(ThemeUtils.getCurrentTheme().getDFLNumberColor());
    public static final Color REGULAR_COLOR = ThemeUtils.getCurrentTheme().getForegroundColor();

    public XPathScanner() {
        ArrayList<Object> rules = new ArrayList<Object>();
        XPathStringToken stringToken = new XPathStringToken(new TextAttribute(STRING_COLOR));
        XPathNumberToken numberToken = new XPathNumberToken(new TextAttribute(NUMBER_COLOR));
        XPathIdentifierToken identifierToken = new XPathIdentifierToken(new TextAttribute(REGULAR_COLOR));
        rules.add(new SingleLineRule("\"", "\"", (IToken)stringToken, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)stringToken, '\\'));
        rules.add(new DecimalNumberRule((IToken)numberToken));
        rules.add(new WhitespaceRule(new IWhitespaceDetector(){

            public boolean isWhitespace(char c) {
                return Character.isWhitespace(c);
            }
        }));
        Enum[] enumArray = XPathSelector.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            XPathSelector selector = enumArray[n2];
            rules.add(new OperatorRule((IToken)new XPathSelectorToken(KEYWORD_COLOR, selector), selector.getLiteral()));
            ++n2;
        }
        enumArray = XPathOperator.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum operator = enumArray[n2];
            rules.add(new OperatorRule((IToken)new XPathOperatorToken(KEYWORD_COLOR, (XPathOperator)operator), ((XPathOperator)operator).getLiteral()));
            ++n2;
        }
        enumArray = XPathBracket.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum xpathBracket = enumArray[n2];
            rules.add(new XPathBracketRule((IToken)new XPathBracketToken(REGULAR_COLOR, (XPathBracket)xpathBracket), ((XPathBracket)xpathBracket).getLiteral()));
            ++n2;
        }
        WordRule identifierRules = new WordRule(new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isJavaIdentifierStart(c);
            }

            public boolean isWordPart(char c) {
                return Character.isJavaIdentifierPart(c) || c == ':';
            }
        }, (IToken)identifierToken, true);
        rules.add(identifierRules);
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }
}

