/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.xpath;

import java.util.Stack;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathBracketToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathIdentifierToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathNumberToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathOperatorToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathScanner;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathSelectorToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathStringToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathToken;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.XPathTokenVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathFilterNode;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathFunctionNode;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathIdentifierNode;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathNode;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathNumberLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathSelectorNode;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathStatementNode;
import org.mule.tooling.ui.modules.core.autocomplete.xpath.ast.XPathStringLiteralNode;

public class XPathParser {
    private IDocument document;
    private IRegion range;

    public XPathParser(String text) {
        this((IDocument)new Document(text));
    }

    public XPathParser(IDocument document) {
        this(document, (IRegion)new Region(0, document.getLength()));
    }

    public XPathParser(IDocument document, IRegion range) {
        this.document = document;
        this.range = range;
    }

    public XPathNode parse() {
        XPathScanner scanner = new XPathScanner();
        scanner.setRange(this.document, this.range.getOffset(), this.range.getLength());
        XPathNodeVistor visitor = new XPathNodeVistor();
        IToken token = scanner.nextToken();
        while (!token.isEOF()) {
            if (token instanceof XPathToken) {
                XPathToken richToken = (XPathToken)token;
                int tokenOffset = scanner.getTokenOffset();
                int tokenLength = scanner.getTokenLength();
                try {
                    String tokenText = this.document.get(tokenOffset, tokenLength);
                    richToken.setTokenText(tokenText);
                }
                catch (BadLocationException badLocationException) {}
                richToken.accept(visitor);
            }
            token = scanner.nextToken();
        }
        return visitor.getResult();
    }

    private class XPathNodeVistor
    implements XPathTokenVisitor {
        private XPathNode lastNode = new XPathStatementNode();
        private Stack<XPathStatementNode> scopes = new Stack();

        private XPathNodeVistor() {
        }

        @Override
        public void acceptBracketToken(XPathBracketToken token) {
            switch (token.getBracket()) {
                case CLOSE_PAREN: {
                    this.lastNode = this.scopes.pop().getParent();
                    break;
                }
                case CLOSE_SQUARE_BRACKET: {
                    this.lastNode = this.scopes.pop().getParent();
                    break;
                }
                case OPEN_PAREN: {
                    if (this.lastNode instanceof XPathIdentifierNode) {
                        XPathNode name = this.lastNode;
                        this.lastNode = name.getParent();
                        name.getParent().removeChild(name);
                        XPathFunctionNode functionNode = new XPathFunctionNode((XPathIdentifierNode)name);
                        this.addNode(functionNode);
                        XPathStatementNode arguments = functionNode.getArguments();
                        this.scopes.push(arguments);
                        this.lastNode = arguments;
                        break;
                    }
                    XPathStatementNode statement = new XPathStatementNode();
                    this.addNode(statement);
                    this.scopes.push(statement);
                    break;
                }
                case OPEN_SQUARE_BRACKET: {
                    XPathFilterNode filterNode = new XPathFilterNode();
                    this.addNode(filterNode);
                    XPathStatementNode filter = filterNode.getFilter();
                    this.scopes.push(filter);
                    this.lastNode = filter;
                    break;
                }
            }
        }

        public XPathNode getResult() {
            return this.lastNode.getRoot();
        }

        @Override
        public void acceptNumberToken(XPathNumberToken token) {
            this.addNode(new XPathNumberLiteralNode(token.getTokenText()));
        }

        private void addNode(XPathNode node) {
            XPathNode parent = this.lastNode;
            if (parent != null && parent.getPrecedence() >= node.getPrecedence()) {
                while (parent != null && parent.getPrecedence() >= node.getPrecedence()) {
                    parent = parent.getParent();
                }
                if (parent != null) {
                    XPathNode lastChild = parent.getLastChild();
                    if (lastChild != null) {
                        parent.removeChild(lastChild);
                        node.addChild(lastChild);
                    }
                    parent.addChild(node);
                } else {
                    node.addChild(this.lastNode.getRoot());
                }
            } else {
                this.lastNode.addChild(node);
            }
            this.lastNode = node;
        }

        @Override
        public void acceptStringToken(XPathStringToken token) {
            String tokenText = token.getTokenText();
            this.addNode(new XPathStringLiteralNode(tokenText.substring(1, tokenText.length() - 1)));
        }

        @Override
        public void acceptOperatorToken(XPathOperatorToken token) {
            this.addNode(new XPathOperatorNode(token.getOperator()));
        }

        @Override
        public void acceptIdentifierToken(XPathIdentifierToken xPathIdentifierToken) {
            this.addNode(new XPathIdentifierNode(xPathIdentifierToken.getTokenText()));
        }

        @Override
        public void acceptSelectorToken(XPathSelectorToken xPathSelectorToken) {
            this.addNode(new XPathSelectorNode(xPathSelectorToken.getSelector()));
        }
    }
}

