/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.proposal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class SignatureUtils {
    public static List<IRegion> resolveRegions(String script, String[] parameters) {
        ArrayList<IRegion> regions = new ArrayList<IRegion>();
        int lastParameterOffset = script.indexOf(40);
        int lastParameterLength = 0;
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            lastParameterOffset = script.indexOf(SignatureUtils.formatName(parameter), lastParameterOffset + lastParameterLength);
            lastParameterLength = parameter.length();
            regions.add((IRegion)new Region(lastParameterOffset, lastParameterLength));
            ++n2;
        }
        return regions;
    }

    public static String getSignature(String name, String[] parameters) {
        return SignatureUtils.getSignatureBuilder(name, parameters).toString();
    }

    public static String getFullSignature(String name, String[] parameters, String returnType) {
        return SignatureUtils.getSignatureBuilder(name, parameters).append(" : ").append(returnType).toString();
    }

    private static StringBuilder getSignatureBuilder(String name, String[] parameters) {
        StringBuilder signature = new StringBuilder(name);
        signature.append("(");
        int i = 0;
        while (i < parameters.length) {
            if (i > 0) {
                signature.append(",");
            }
            signature.append(parameters[i]);
            ++i;
        }
        signature.append(")");
        return signature;
    }

    private static String formatName(String typeSimpleName) {
        return StringUtils.uncapitalize((String)typeSimpleName);
    }
}

