/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.proposal;

import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.IRegion;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FieldDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.analyzer.FunctionDefinition;
import org.mule.tooling.ui.modules.core.autocomplete.mel.templates.CompletionTemplate;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.FieldCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.JavaClassCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.JavadocRetrieverImpl;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.KeywordCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.MapKeyCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.MethodCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.PackageCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.SignatureUtils;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.TemplateCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.utils.JavaModelUtils;

public class ProposalFactory {
    public static final String CONTENT_TYPE = "org.mule.tooling.autocomplete.parser.MELDocumentPartitioner.MEL_CONTENT_TYPE";

    public static FieldCompletionProposal createFieldProposal(String script, String label, String doc, IRegion replacementRange, int cursorPosition) {
        return new FieldCompletionProposal(script, label, doc, replacementRange, cursorPosition);
    }

    public static FieldCompletionProposal createFieldProposal(IField field, String label, IRegion replacementRange) {
        return new FieldCompletionProposal(field.getElementName(), label, label, replacementRange);
    }

    public static FieldCompletionProposal createFieldProposal(String script, String label, String doc, IRegion replacementRange) {
        return new FieldCompletionProposal(script, label, doc, replacementRange);
    }

    public static FieldCompletionProposal createFieldProposal(FieldDefinition fieldDefinition, IRegion replacementRange) {
        return ProposalFactory.createFieldProposal(fieldDefinition.getName(), fieldDefinition.getLabel(), fieldDefinition.getDescription(), replacementRange);
    }

    public static JavaClassCompletionProposal createJavaClassProposal(String script, String label, String doc, IRegion replacementRange) {
        return new JavaClassCompletionProposal(script, label, doc, replacementRange);
    }

    public static KeywordCompletionProposal createKeywordProposal(String script, IRegion replacementRange) {
        return new KeywordCompletionProposal(script, replacementRange);
    }

    public static PackageCompletionProposal createPackageProposal(String packageName, IRegion replacementRange) {
        return new PackageCompletionProposal(packageName, replacementRange);
    }

    public static MethodCompletionProposal createMethodProposal(IMethod method, IRegion replacementRange) throws JavaModelException {
        String returnType = JavaModelUtils.getResolvedTypeName(method.getReturnType(), method.getDeclaringType());
        String name = method.getElementName();
        String[] parameters = method.getParameterNames();
        String signature = SignatureUtils.getSignature(name, parameters);
        List<IRegion> variables = SignatureUtils.resolveRegions(signature, parameters);
        String fullSignature = SignatureUtils.getFullSignature(name, parameters, returnType);
        JavadocRetrieverImpl javadocRetriever = new JavadocRetrieverImpl((IMember)method, returnType);
        return new MethodCompletionProposal(javadocRetriever, new CompletionTemplate(fullSignature, "", signature, CONTENT_TYPE, variables), replacementRange);
    }

    public static MethodCompletionProposal createMethodProposal(FunctionDefinition methodDefinition, IRegion replacementRange) {
        String name = methodDefinition.getName();
        String[] parameters = methodDefinition.getParameters();
        String fullSignature = SignatureUtils.getFullSignature(name, parameters, methodDefinition.getReturnType());
        String signature = SignatureUtils.getSignature(name, parameters);
        String description = methodDefinition.getDescription();
        CompletionTemplate completionTemplate = new CompletionTemplate(fullSignature, description, signature, CONTENT_TYPE, SignatureUtils.resolveRegions(signature, parameters));
        return new MethodCompletionProposal(completionTemplate, replacementRange);
    }

    public static TemplateCompletionProposal createTemplateProposal(String pattern, String name, String description, List<IRegion> variables, IRegion replacementRange) {
        return new TemplateCompletionProposal(new CompletionTemplate(name, description, pattern, CONTENT_TYPE, variables), replacementRange);
    }

    public static FieldCompletionProposal createMapKeyFieldProposal(String script, String label, String doc, IRegion replacementRange) {
        return new MapKeyCompletionProposal(script, label, doc, replacementRange);
    }
}

