/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.proposal;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Point;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.Operator;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.FieldCompletionProposal;

public class MapKeyCompletionProposal
extends FieldCompletionProposal {
    private IRegion replacementRegion;

    public MapKeyCompletionProposal(String replacementString, String label, String documentation, IRegion replacementRegion) {
        super(replacementString, label, documentation, replacementRegion);
        this.setReplacementRegion(replacementRegion);
    }

    @Override
    public void apply(IDocument document) {
        this.buildReplacementString(document);
        try {
            document.replace(this.getReplacementRegion().getOffset(), this.getReplacementRegion().getLength(), this.getReplacementString());
        }
        catch (BadLocationException badLocationException) {}
    }

    private void buildReplacementString(IDocument document) {
        StringBuilder builder = new StringBuilder();
        String previousChar = this.getPreviousIdentifierChar(document);
        Boolean isPreviousOpenBrackets = "[".equals(previousChar);
        String postChar = this.getPostIdentifierChar(document);
        Boolean identifierContainOperator = this.identifierContainAnyOperator();
        this.appendOppositeQuoteIfNeeded(builder, identifierContainOperator != false || isPreviousOpenBrackets != false, previousChar, postChar);
        builder.append(this.getReplacementString());
        this.appendOppositeQuoteIfNeeded(builder, identifierContainOperator != false || isPreviousOpenBrackets != false, postChar, previousChar);
        this.setReplacementString(builder.toString());
    }

    private boolean identifierContainAnyOperator() {
        String identifier = this.getReplacementString();
        boolean haveSpace = identifier.contains(" ");
        return haveSpace || Operator.containsOperator(identifier);
    }

    private boolean isQuote(String charito) {
        return charito != null && (charito.equals("'") || charito.equals("\""));
    }

    private String getPreviousIdentifierChar(IDocument document) {
        String previousChar = null;
        try {
            previousChar = document.get(this.getReplacementRegion().getOffset() - 1, 1);
        }
        catch (BadLocationException badLocationException) {}
        return previousChar;
    }

    private String getPostIdentifierChar(IDocument document) {
        String postChar = null;
        try {
            postChar = document.get(this.getReplacementRegion().getOffset() + this.getReplacementRegion().getLength(), 1);
        }
        catch (BadLocationException badLocationException) {}
        return postChar;
    }

    private void appendOppositeQuoteIfNeeded(StringBuilder builder, Boolean forceQuote, String actualChar, String oppositeChar) {
        Boolean isActualCharAQuote = this.isQuote(actualChar);
        Boolean isOppositeCharAQuote = this.isQuote(oppositeChar);
        if (!isActualCharAQuote.booleanValue()) {
            String quote = "'";
            if (isOppositeCharAQuote.booleanValue()) {
                quote = oppositeChar;
            }
            if (forceQuote.booleanValue() || isOppositeCharAQuote.booleanValue()) {
                builder.append(quote);
            }
        }
    }

    @Override
    public Point getSelection(IDocument document) {
        return new Point(this.getReplacementRegion().getOffset() + this.getReplacementString().length(), 0);
    }

    public IRegion getReplacementRegion() {
        return this.replacementRegion;
    }

    public void setReplacementRegion(IRegion replacementRegion) {
        this.replacementRegion = replacementRegion;
    }
}

