/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.proposal;

import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.JavadocRetriever;

public class JavadocRetrieverImpl
implements JavadocRetriever {
    private IMember member;
    private String simpleJavadoc;
    private String javadoc;

    public JavadocRetrieverImpl(String javadoc) {
        this.javadoc = javadoc;
    }

    public JavadocRetrieverImpl(IMember member) {
        this.member = member;
    }

    public JavadocRetrieverImpl(IMember member, String simpleJavadoc) {
        this.member = member;
        this.simpleJavadoc = simpleJavadoc;
    }

    @Override
    public String getJavadoc() {
        if (this.javadoc != null) {
            return this.javadoc;
        }
        String retrievedJavadoc = this.retrieveJavadoc();
        boolean javadocNotBlank = StringUtils.isNotBlank((String)retrievedJavadoc);
        if (javadocNotBlank) {
            this.javadoc = retrievedJavadoc;
            return retrievedJavadoc;
        }
        return this.getSimpleJavadoc();
    }

    private String getSimpleJavadoc() {
        return this.simpleJavadoc != null ? this.simpleJavadoc : "";
    }

    private String retrieveJavadoc() {
        Reader htmlContentReader = null;
        try {
            htmlContentReader = this.member.getOpenable() != null ? JavadocContentAccess.getHTMLContentReader((IMember)this.member, (boolean)true, (boolean)true) : null;
            return htmlContentReader != null ? this.getString(htmlContentReader) : null;
        }
        catch (JavaModelException e) {
            MuleCorePlugin.logError((String)"Error retrieving javadoc", (Throwable)e);
            return null;
        }
    }

    private String getString(Reader reader) {
        try {
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }
}

