/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.proposal;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.ComparableCompletionProposal;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.JavadocRetriever;
import org.mule.tooling.ui.modules.core.autocomplete.proposal.JavadocRetrieverImpl;

public abstract class AbstractCompletionProposal
implements ComparableCompletionProposal {
    private String displayString;
    private String replacementString;
    private int replacementOffset;
    private int replacementLength;
    private int cursorPosition;
    private IContextInformation contextInformation;
    private JavadocRetriever additionalProposalInfo;

    public AbstractCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, String displayString, IContextInformation contextInformation, JavadocRetriever additionalProposalInfo) {
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.cursorPosition = cursorPosition;
        this.displayString = displayString;
        this.contextInformation = contextInformation;
        this.additionalProposalInfo = additionalProposalInfo;
    }

    public AbstractCompletionProposal(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, String displayString, IContextInformation contextInformation, String additionalProposalInfo) {
        this(replacementString, replacementOffset, replacementLength, cursorPosition, displayString, contextInformation, new JavadocRetrieverImpl(additionalProposalInfo));
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replacementOffset, this.replacementLength, this.replacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.replacementOffset + this.cursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.contextInformation;
    }

    public abstract Image getImage();

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        return this.replacementString;
    }

    public String getAdditionalProposalInfo() {
        return this.additionalProposalInfo.getJavadoc();
    }

    @Override
    public int compareTo(ICompletionProposal o) {
        return this.getDisplayString().compareTo(o.getDisplayString());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.displayString == null ? 0 : this.displayString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCompletionProposal other = (AbstractCompletionProposal)obj;
        return !(this.displayString == null ? other.displayString != null : !this.displayString.equals(other.displayString));
    }

    public String toString() {
        return "AbstractCompletionProposal [fDisplayString=" + this.displayString + ", fReplacementString=" + this.replacementString + ", fReplacementOffset=" + this.replacementOffset + ", fReplacementLength=" + this.replacementLength + ", fCursorPosition=" + this.cursorPosition + ", fContextInformation=" + String.valueOf(this.contextInformation) + ", fAdditionalProposalInfo=" + String.valueOf(this.additionalProposalInfo) + "]";
    }

    public String getReplacementString() {
        return this.replacementString;
    }

    public void setReplacementString(String replacementString) {
        this.replacementString = replacementString;
    }

    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    public int getReplacementLength() {
        return this.replacementLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }
}

