/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.parser;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.Operator;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ASTNodeVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IASTNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IContainerAwareNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IContentAwareNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MELLocation;
import org.mule.tooling.utils.ObjectHolder;

public class UnaryOperatorNode
implements IContentAwareNode,
IOperatorNode {
    private final Operator operator;
    private ObjectHolder<IASTNode> operand = new ObjectHolder();
    private IContainerAwareNode parent;
    private MELLocation location;

    public UnaryOperatorNode(String operatorStr, MELLocation location) {
        this.location = location;
        this.operator = Operator.fromString(operatorStr);
    }

    public UnaryOperatorNode(Operator operator, MELLocation location) {
        this.operator = operator;
        this.location = location;
    }

    @Override
    public void setContent(String name) {
    }

    public Operator getOperator() {
        return this.operator;
    }

    public IASTNode getOperand() {
        return (IASTNode)this.operand.get();
    }

    @Override
    public String getContent() {
        return this.operator.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Operator( '");
        stringBuffer.append((Object)this.operator);
        stringBuffer.append("', operand={").append(String.valueOf(this.getOperand())).append("} ");
        return stringBuffer.toString();
    }

    @Override
    public void accept(ASTNodeVisitor visitor) {
        visitor.visitUnaryOperator(this);
    }

    @Override
    public int getPrecedence() {
        return this.operator.getPrecedence();
    }

    @Override
    public IContainerAwareNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IContainerAwareNode parent) {
        this.parent = parent;
    }

    @Override
    public void addChild(IASTNode child) {
        this.operand.set((Object)child);
        child.setParent(this);
    }

    @Override
    public LinkedList<IASTNode> getChildren() {
        LinkedList newList = Lists.newLinkedList();
        newList.add((IASTNode)this.operand.get());
        return newList;
    }

    @Override
    public boolean isClosed() {
        return !this.operand.isNull();
    }

    @Override
    public void setClosed(boolean b) {
    }

    public IASTNode getChild() {
        return this.getChildren().isEmpty() ? null : this.getChildren().get(0);
    }

    @Override
    public IASTNode removeLastChild() {
        return (IASTNode)this.operand.set(null);
    }

    @Override
    public LinkedList<IASTNode> removeChildren() {
        LinkedList removedChildren = Lists.newLinkedList();
        removedChildren.add(this.removeLastChild());
        return removedChildren;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryOperatorNode other = (UnaryOperatorNode)obj;
        return this.operator == other.operator;
    }

    @Override
    public MELLocation getLocation() {
        if (this.getChild() == null) {
            return this.location;
        }
        MELLocation rightLocation = this.getChild().getLocation();
        return new MELLocation(this.location.getColumn(), this.location.getOffset(), rightLocation.getOffset() - this.location.getOffset() + rightLocation.getLength(), this.location.getDocument());
    }
}

