/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.parser;

import java.util.LinkedList;
import org.apache.commons.collections.CollectionUtils;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ASTNodeVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IASTNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IContainerAwareNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IContentAwareNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MELLocation;

public class MethodCallNode
implements IContainerAwareNode,
IContentAwareNode {
    private String name;
    private LinkedList<IASTNode> innerElements;
    private boolean closed;
    private IContainerAwareNode parent;
    private MELLocation methodLocation;

    public MethodCallNode(MELLocation methodLocation) {
        this.methodLocation = methodLocation;
        this.innerElements = new LinkedList();
        this.closed = false;
    }

    public MethodCallNode(String name, MELLocation methodLocation) {
        this(methodLocation);
        this.name = name;
    }

    public int getNumberOfArguments() {
        return this.innerElements.size();
    }

    @Override
    public LinkedList<IASTNode> getChildren() {
        return this.innerElements;
    }

    @Override
    public void addChild(IASTNode child) {
        this.innerElements.add(child);
        child.setParent(this);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.closed ? 1231 : 1237);
        result = 31 * result + (this.innerElements == null ? 0 : this.innerElements.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodCallNode other = (MethodCallNode)obj;
        if (this.closed != other.closed) {
            return false;
        }
        if (this.innerElements == null ? other.innerElements != null : !CollectionUtils.isEqualCollection(this.innerElements, other.innerElements)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MethodCall");
        stringBuffer.append(this.closed ? "(Closed) " : "(Open) ");
        stringBuffer.append("name=" + this.name + ", innerElements=" + String.valueOf(this.innerElements));
        return stringBuffer.toString();
    }

    @Override
    public void accept(ASTNodeVisitor visitor) {
        visitor.visitMethodCall(this);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public void setContent(String content) {
        this.name = content;
    }

    @Override
    public String getContent() {
        return this.name;
    }

    @Override
    public IASTNode removeLastChild() {
        IASTNode removed = this.innerElements.removeLast();
        removed.setParent(null);
        return removed;
    }

    @Override
    public LinkedList<IASTNode> removeChildren() {
        LinkedList<IASTNode> removedChildren = new LinkedList<IASTNode>(this.innerElements);
        for (IASTNode removedChild : removedChildren) {
            removedChild.setParent(null);
        }
        this.innerElements = new LinkedList();
        return removedChildren;
    }

    @Override
    public IContainerAwareNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IContainerAwareNode parent) {
        this.parent = parent;
    }

    @Override
    public MELLocation getLocation() {
        if (this.getChildren().isEmpty()) {
            return this.methodLocation;
        }
        MELLocation startLocation = this.methodLocation;
        MELLocation endLocation = this.getChildren().get(this.getChildren().size() - 1).getLocation();
        return new MELLocation(startLocation.getColumn() + startLocation.getLength(), startLocation.getOffset(), endLocation.getOffset() - startLocation.getOffset() + endLocation.getLength() + 1, this.methodLocation.getDocument());
    }
}

