/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.parser;

import java.util.LinkedList;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.IToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.ITokenVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.MELScanner;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.BracketToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.CommentToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.IdentifierToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.Keyword;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.KeywordToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.NumberLiteralToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.Operator;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.OperatorToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.RichToken;
import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.StringLiteralToken;
import org.mule.tooling.ui.modules.core.autocomplete.parser.BinaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CollectionAccessNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.CommentNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IASTNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IContainerAwareNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IdentifierNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.InlineCollectionNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.KeywordNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MELLocationProvider;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MapEntryNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MethodCallNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.NumberLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ScriptNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StatementNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.StringLiteralNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.UnaryOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.VariableDeclarationNode;

public class MELParser {
    private IDocument document;
    private IRegion range;

    public MELParser() {
    }

    public MELParser(String text) {
        this((IDocument)new Document(text));
    }

    public MELParser(IDocument document) {
        this(document, (IRegion)new Region(0, document.getLength()));
    }

    public MELParser(IDocument document, IRegion range) {
        this.document = document;
        this.range = range;
    }

    public ScriptNode parse() {
        MELScanner scanner = new MELScanner();
        MELLocationProvider locationProvider = new MELLocationProvider(scanner, this.document);
        TokenVisitor visitor = new TokenVisitor(locationProvider);
        scanner.setRange(this.document, this.range.getOffset(), this.range.getLength());
        IToken token = scanner.nextToken();
        while (!token.isEOF()) {
            if (token instanceof RichToken) {
                RichToken richToken = (RichToken)token;
                this.fillRichToken(scanner, richToken);
                richToken.accept(visitor);
            }
            token = scanner.nextToken();
        }
        ScriptNode result = visitor.getResult();
        return result;
    }

    private void fillRichToken(MELScanner scanner, RichToken richToken) {
        int tokenOffset = scanner.getTokenOffset();
        int tokenLength = scanner.getTokenLength();
        try {
            String tokenText = this.document.get(tokenOffset, tokenLength);
            richToken.setText(tokenText);
            richToken.setOffset(tokenOffset);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void setDocument(Document newDocument) {
        this.document = newDocument;
    }

    public void setRange(Region newRange) {
        this.range = newRange;
    }

    public class TokenVisitor
    implements ITokenVisitor {
        private LinkedList<IContainerAwareNode> containers;
        private Stack<BracketToken.Bracket> bracketStack;
        private ScriptNode result;
        private IASTNode lastAddedNode;
        private MELLocationProvider locationProvider;

        public TokenVisitor(MELLocationProvider locationProvider) {
            this.locationProvider = locationProvider;
            this.result = new ScriptNode();
            this.containers = new LinkedList();
            this.containers.add(this.result);
            this.bracketStack = new Stack();
        }

        @Override
        public void visitKeyword(KeywordToken keywordToken) {
            Keyword keyword = keywordToken.getKeyword();
            if (keyword.equals((Object)Keyword.NEW)) {
                UnaryOperatorNode intanceCreationNode = new UnaryOperatorNode(keyword.toString(), this.locationProvider.getLocation());
                this.addChildContainerToLastContainer(intanceCreationNode);
            } else {
                KeywordNode child = new KeywordNode(keywordToken.getText(), this.locationProvider.getLocation());
                this.addChildToLastContainer(child);
            }
        }

        @Override
        public void visitComment(CommentToken commentToken) {
            this.addChildToLastContainer(new CommentNode(commentToken.getText(), this.locationProvider.getLocation()));
        }

        @Override
        public void visitStringLiteral(StringLiteralToken stringLiteralToken) {
            String text = stringLiteralToken.getText();
            boolean hasDoubleQuotes = text.startsWith("\"");
            StringLiteralNode child = new StringLiteralNode(text.substring(1, text.length() - 1), hasDoubleQuotes, this.locationProvider.getLocation());
            this.addChildToLastContainer(child);
        }

        @Override
        public void visitNumberLiteral(NumberLiteralToken numberLiteral) {
            NumberLiteralNode child = new NumberLiteralNode(numberLiteral.getText(), this.locationProvider.getLocation());
            this.addChildToLastContainer(child);
        }

        @Override
        public void visitOperator(OperatorToken operatorToken) {
            Operator operator = operatorToken.getOperator();
            IContainerAwareNode lastContainer = this.containers.getLast();
            switch (operator) {
                case COMMA: {
                    break;
                }
                case SEMICOLON: {
                    if (this.containers.getLast() instanceof ScriptNode) break;
                    IContainerAwareNode container = this.containers.removeLast();
                    while (!(container instanceof StatementNode) && !this.containers.isEmpty()) {
                        container = this.containers.removeLast();
                    }
                    container.setClosed(true);
                    break;
                }
                case INCREMENT: 
                case DECREMENT: 
                case EXCLAMATION: {
                    UnaryOperatorNode unaryOperator = new UnaryOperatorNode(operator, this.locationProvider.getLocation());
                    this.addOperator(unaryOperator, lastContainer, this.isPrefix(operator));
                    break;
                }
                case COLON: {
                    if (lastContainer instanceof InlineCollectionNode) {
                        InlineCollectionNode inlineCollection = (InlineCollectionNode)lastContainer;
                        inlineCollection.setType(InlineCollectionNode.Type.MAP);
                        MapEntryNode mapEntryNode = this.createMapEntryNode(inlineCollection);
                        this.addChildContainerToLastContainer(mapEntryNode);
                        break;
                    }
                    BinaryOperatorNode operatorNode = new BinaryOperatorNode(operator, this.locationProvider.getLocation());
                    this.addOperator(operatorNode, lastContainer);
                    break;
                }
                default: {
                    BinaryOperatorNode operatorNode = new BinaryOperatorNode(operator, this.locationProvider.getLocation());
                    this.addOperator(operatorNode, lastContainer);
                }
            }
        }

        private boolean isPrefix(Operator operator) {
            return operator == Operator.EXCLAMATION;
        }

        private MapEntryNode createMapEntryNode(InlineCollectionNode inlineMap) {
            MapEntryNode mapEntry;
            LinkedList<IASTNode> childrenOfMapNode = inlineMap.getChildren();
            if (childrenOfMapNode.isEmpty()) {
                mapEntry = new MapEntryNode(null);
            } else {
                IASTNode childOfLastContainer = inlineMap.removeLastChild();
                mapEntry = new MapEntryNode(childOfLastContainer);
            }
            return mapEntry;
        }

        private void addOperator(IOperatorNode operator, IContainerAwareNode lastContainer) {
            this.addOperator(operator, lastContainer, false);
        }

        private void addOperator(IOperatorNode operator, IContainerAwareNode lastContainer, boolean prefixOperator) {
            LinkedList<IASTNode> children = lastContainer.getChildren();
            if (children.isEmpty()) {
                this.addChildContainerToLastContainer(operator);
            } else if (children.size() > 1 && this.isAssignmentOperator(operator)) {
                VariableDeclarationNode varDeclaration = new VariableDeclarationNode();
                LinkedList<IASTNode> removedChildren = lastContainer.removeChildren();
                for (IASTNode child : removedChildren) {
                    varDeclaration.addChild(child);
                }
                operator.addChild(varDeclaration);
                this.addChildContainerToLastContainer(operator);
            } else {
                IASTNode childOfLastContainer = children.getLast();
                IASTNode toReplace = this.getChildToReplace(childOfLastContainer, operator);
                IContainerAwareNode parent = toReplace.getParent();
                if (!prefixOperator) {
                    operator.addChild(parent.removeLastChild());
                }
                if (parent != lastContainer) {
                    this.containers.add(parent);
                }
                this.addChildContainerToLastContainer(operator);
            }
        }

        private IASTNode getChildToReplace(IASTNode node, IOperatorNode toInsert) {
            if (this.firstHasMorePrecedence(toInsert, node)) {
                IASTNode lastChild = ((IOperatorNode)node).getChildren().getLast();
                return this.getChildToReplace(lastChild, toInsert);
            }
            return node;
        }

        private boolean firstHasMorePrecedence(IASTNode first, IASTNode second) {
            if (!(first instanceof IOperatorNode) || !(second instanceof IOperatorNode)) {
                return false;
            }
            IOperatorNode firstOp = (IOperatorNode)first;
            IOperatorNode secondOp = (IOperatorNode)second;
            return firstOp.getPrecedence() > secondOp.getPrecedence();
        }

        @Override
        public void visitBracket(BracketToken bracketToken) {
            BracketToken.Bracket bracket = bracketToken.getBracket();
            switch (bracket) {
                case PARENTHESIS_OPEN: {
                    if (this.lastAddedNode instanceof IdentifierNode) {
                        IContainerAwareNode parentOfLastAdded = this.lastAddedNode.getParent();
                        IdentifierNode identifier = (IdentifierNode)parentOfLastAdded.removeLastChild();
                        MethodCallNode methodCallExpression = new MethodCallNode(identifier.getContent(), identifier.getLocation());
                        this.doAddChild(parentOfLastAdded, methodCallExpression);
                        this.containers.add(methodCallExpression);
                    } else {
                        this.addChildContainerToLastContainer(new StatementNode());
                    }
                    this.bracketStack.push(bracket);
                    break;
                }
                case PARENTHESIS_CLOSE: {
                    if (!this.lastBracketIs(BracketToken.Bracket.PARENTHESIS_OPEN)) break;
                    this.bracketStack.pop();
                    this.endCurrentStatement();
                    break;
                }
                case BRACKET_OPEN: {
                    IContainerAwareNode lastContainer = this.containers.getLast();
                    LinkedList<IASTNode> childrenOfLastContainer = lastContainer.getChildren();
                    boolean acceptsCollAccessNode = this.acceptsCollectionAccessNodeNext(this.lastAddedNode, childrenOfLastContainer);
                    if (CollectionUtils.isNotEmpty(childrenOfLastContainer) && acceptsCollAccessNode) {
                        CollectionAccessNode collectionAccessNode = new CollectionAccessNode(this.locationProvider.getLocation());
                        this.addOperator(collectionAccessNode, lastContainer);
                        this.bracketStack.push(bracket);
                        break;
                    }
                    this.addChildContainerToLastContainer(new InlineCollectionNode(this.locationProvider.getLocation()));
                    this.bracketStack.push(bracket);
                    break;
                }
                case BRACKET_CLOSE: {
                    if (!this.lastBracketIs(BracketToken.Bracket.BRACKET_OPEN)) break;
                    this.bracketStack.pop();
                    this.endCurrentStatement();
                    break;
                }
                case CURLY_BRACE_OPEN: {
                    break;
                }
                case CURLY_BRACE_CLOSE: {
                    break;
                }
            }
        }

        private boolean acceptsCollectionAccessNodeNext(IASTNode node) {
            return node instanceof IdentifierNode || node instanceof MethodCallNode || node instanceof CollectionAccessNode;
        }

        private boolean acceptsCollectionAccessNodeNext(IASTNode lastAdded, LinkedList<IASTNode> childrenOfLastContainer) {
            boolean lastAddedNodeAccepts;
            boolean lastBrotherAccepts = false;
            if (!childrenOfLastContainer.isEmpty()) {
                lastBrotherAccepts = this.acceptsCollectionAccessNodeNext(childrenOfLastContainer.getLast());
            }
            return (lastAddedNodeAccepts = this.acceptsCollectionAccessNodeNext(lastAdded)) || lastBrotherAccepts;
        }

        @Override
        public void visitIdentifier(IdentifierToken identifierToken) {
            IdentifierNode child = new IdentifierNode(identifierToken.getText(), this.locationProvider.getLocation());
            this.addChildToLastContainer(child);
        }

        private boolean lastBracketIs(BracketToken.Bracket bracket) {
            return !this.bracketStack.isEmpty() && this.bracketStack.peek().equals((Object)bracket);
        }

        private void addChildContainerToLastContainer(IContainerAwareNode child) {
            this.addChildToLastContainer(child);
            if (!child.isClosed()) {
                this.containers.add(child);
            }
        }

        private void addChildToLastContainer(IASTNode child) {
            if (child == this.containers.getLast()) {
                throw new IllegalArgumentException("Failed to add child to last container, as the child is the last container");
            }
            if (this.containers.getLast().isClosed()) {
                this.containers.removeLast();
            }
            if (this.requiresStatement(this.containers.getLast())) {
                StatementNode statement = new StatementNode();
                this.containers.getLast().addChild(statement);
                this.containers.add(statement);
            }
            this.doAddChild(this.containers.getLast(), child);
            if (this.isClosedOperatorNode(this.containers.getLast()) && !this.isAssignmentOperator(this.containers.getLast())) {
                this.endCurrentStatement();
            }
        }

        private boolean isAssignmentOperator(IASTNode node) {
            if (node instanceof BinaryOperatorNode) {
                BinaryOperatorNode operatorNode = (BinaryOperatorNode)node;
                Operator operator = operatorNode.getOperator();
                return operator.equals((Object)Operator.EQUAL);
            }
            return false;
        }

        private boolean isClosedOperatorNode(IContainerAwareNode container) {
            return container instanceof IOperatorNode && container.isClosed();
        }

        private boolean requiresStatement(IContainerAwareNode container) {
            return container instanceof ScriptNode;
        }

        private void doAddChild(IContainerAwareNode container, IASTNode child) {
            container.addChild(child);
            this.lastAddedNode = child;
        }

        private void endCurrentStatement() {
            IContainerAwareNode container = this.containers.removeLast();
            container.setClosed(true);
        }

        public ScriptNode getResult() {
            return this.result;
        }
    }
}

