/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.parser;

import org.mule.tooling.ui.modules.core.autocomplete.parser.ASTNodeVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.parser.AbstractContainerNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MELLocation;

public class InlineCollectionNode
extends AbstractContainerNode {
    private Type type = Type.LIST;
    private MELLocation location;

    public InlineCollectionNode(MELLocation location) {
        this.location = location;
    }

    @Override
    public void accept(ASTNodeVisitor visitor) {
        visitor.visitInlineCollectionNode(this);
    }

    protected void setType(Type type) {
        this.type = type;
    }

    public void setTypeToMap() {
        this.setType(Type.MAP);
    }

    public void setTypeToList() {
        this.setType(Type.LIST);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InlineCollectionNode other = (InlineCollectionNode)obj;
        return this.type == other.type;
    }

    @Override
    public String toString() {
        String closedStr = this.closed ? "(Closed) " : "(Open) ";
        return "InlineCollection" + closedStr + "{" + String.valueOf(this.innerElements) + "}";
    }

    @Override
    public MELLocation getLocation() {
        if (this.getChildren().isEmpty()) {
            return this.location;
        }
        MELLocation startLocation = this.location;
        MELLocation endLocation = this.getChildren().get(this.getChildren().size() - 1).getLocation();
        return new MELLocation(startLocation.getColumn() + startLocation.getLength(), startLocation.getOffset(), endLocation.getOffset() - startLocation.getOffset() + endLocation.getLength(), this.location.getDocument());
    }

    public static enum Type {
        MAP,
        LIST;

    }
}

