/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.parser;

import org.mule.tooling.ui.modules.core.autocomplete.parser.ASTNodeVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.parser.BinaryNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IASTNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MELLocation;
import org.mule.tooling.ui.modules.core.autocomplete.parser.NullNode;

public class CollectionAccessNode
extends BinaryNode
implements IOperatorNode {
    private MELLocation location;

    public CollectionAccessNode(MELLocation location) {
        this.location = location;
    }

    @Override
    public void accept(ASTNodeVisitor visitor) {
        visitor.visitCollectionAccessNode(this);
    }

    public String toString() {
        String closedStr = this.isClosed() ? "(Closed)" : "(Open)";
        return "CollectionAccessNode" + closedStr + " [left=" + String.valueOf(this.getLeft()) + ", right=" + String.valueOf(this.getRight()) + "]";
    }

    @Override
    public int getPrecedence() {
        return 15;
    }

    @Override
    protected void setRight(IASTNode operand) {
        operand.setParent(this);
        this.right = operand == null ? new NullNode(MELLocation.UNKNOWN_LOCATION) : operand;
    }

    @Override
    public MELLocation getLocation() {
        MELLocation leftLocation = this.location;
        MELLocation rightLocation = this.getRight().getLocation();
        return new MELLocation(leftLocation.getColumn() + leftLocation.getLength(), leftLocation.getOffset(), rightLocation.getOffset() - leftLocation.getOffset() + rightLocation.getLength(), this.location.getDocument());
    }
}

