/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.parser;

import org.mule.tooling.ui.modules.core.autocomplete.mel.scanner.tokens.Operator;
import org.mule.tooling.ui.modules.core.autocomplete.parser.ASTNodeVisitor;
import org.mule.tooling.ui.modules.core.autocomplete.parser.BinaryNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IContentAwareNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IOperatorNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MELLocation;

public class BinaryOperatorNode
extends BinaryNode
implements IContentAwareNode,
IOperatorNode {
    private Operator operator;
    private MELLocation location;

    public BinaryOperatorNode(String operatorStr, MELLocation location) {
        this.location = location;
        this.operator = Operator.fromString(operatorStr);
    }

    public BinaryOperatorNode(Operator operator, MELLocation location) {
        this.operator = operator;
        this.location = location;
    }

    @Override
    public void setContent(String name) {
    }

    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public String getContent() {
        return this.operator.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Operator( '");
        stringBuffer.append((Object)this.operator);
        stringBuffer.append("', left={").append(String.valueOf(this.getLeft())).append("}, ");
        stringBuffer.append("right={").append(String.valueOf(this.getRight()));
        stringBuffer.append("} )");
        return stringBuffer.toString();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryOperatorNode other = (BinaryOperatorNode)obj;
        return this.operator == other.operator;
    }

    @Override
    public void accept(ASTNodeVisitor visitor) {
        visitor.visitOperator(this);
    }

    @Override
    public int getPrecedence() {
        return this.operator.getPrecedence();
    }

    @Override
    public MELLocation getLocation() {
        MELLocation leftLocation = this.getLeft().getLocation();
        MELLocation rightLocation = this.getRight().getLocation();
        return new MELLocation(this.location.getColumn(), leftLocation.getOffset(), rightLocation.getOffset() - leftLocation.getOffset() + rightLocation.getLength(), this.location.getDocument());
    }
}

