/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.parser;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IASTNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IContainerAwareNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MELLocation;
import org.mule.tooling.ui.modules.core.autocomplete.parser.NullNode;

public abstract class BinaryNode
implements IContainerAwareNode {
    private IASTNode left;
    protected IASTNode right;
    private boolean closed = false;
    private IContainerAwareNode parent;

    public BinaryNode() {
    }

    public BinaryNode(IASTNode left) {
        this.setLeft(left);
    }

    @Override
    public void addChild(IASTNode operand) {
        if (this.left != null) {
            this.setRight(operand);
        } else {
            this.setLeft(operand);
        }
    }

    protected void setLeft(IASTNode left) {
        if (left != null) {
            this.left = left;
            this.left.setParent(this);
        } else {
            this.left = new NullNode(MELLocation.UNKNOWN_LOCATION);
            this.left.setParent(this);
        }
    }

    @Override
    public MELLocation getLocation() {
        MELLocation leftLocation = this.getLeft().getLocation();
        MELLocation rightLocation = this.getRight().getLocation();
        return new MELLocation(leftLocation.getColumn() + leftLocation.getLength(), leftLocation.getOffset(), rightLocation.getOffset() - leftLocation.getOffset() + rightLocation.getLength(), leftLocation.getDocument());
    }

    protected void setRight(IASTNode operand) {
        operand.setParent(this);
        this.right = operand == null ? new NullNode(MELLocation.UNKNOWN_LOCATION) : operand;
        this.setClosed(true);
    }

    @Override
    public LinkedList<IASTNode> getChildren() {
        LinkedList<IASTNode> children = new LinkedList<IASTNode>();
        if (this.left != null) {
            children.add(this.left);
        }
        if (this.right != null) {
            children.add(this.right);
        }
        return children;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setClosed(boolean b) {
        this.closed = b;
    }

    @Override
    public IASTNode removeLastChild() {
        if (this.right != null) {
            IASTNode removedChild = this.right;
            removedChild.setParent(null);
            this.right = null;
            this.setClosed(false);
            return removedChild;
        }
        if (this.left != null) {
            IASTNode removedChild = this.left;
            removedChild.setParent(null);
            this.left = null;
            this.setClosed(false);
            return removedChild;
        }
        throw new NoSuchElementException("This node has no children");
    }

    @Override
    public LinkedList<IASTNode> removeChildren() {
        LinkedList<IASTNode> children = this.getChildren();
        this.left = null;
        this.right = null;
        this.setClosed(false);
        return children;
    }

    @Override
    public IContainerAwareNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IContainerAwareNode parent) {
        this.parent = parent;
    }

    public boolean hasLeft() {
        return this.getLeft() != null;
    }

    public boolean hasRight() {
        return this.getRight() != null;
    }

    public IASTNode getLeft() {
        return this.left;
    }

    public IASTNode getRight() {
        return this.right;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.closed ? 1231 : 1237);
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryNode other = (BinaryNode)obj;
        if (this.closed != other.closed) {
            return false;
        }
        if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
            return false;
        }
        return !(this.right == null ? other.right != null : !this.right.equals(other.right));
    }
}

