/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.parser;

import java.util.LinkedList;
import org.apache.commons.collections.CollectionUtils;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IASTNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.IContainerAwareNode;
import org.mule.tooling.ui.modules.core.autocomplete.parser.MELLocation;

public abstract class AbstractContainerNode
implements IContainerAwareNode {
    protected LinkedList<IASTNode> innerElements = new LinkedList();
    protected boolean closed;
    private IContainerAwareNode parent;

    @Override
    public void addChild(IASTNode child) {
        this.innerElements.add(child);
        child.setParent(this);
    }

    @Override
    public LinkedList<IASTNode> getChildren() {
        return this.innerElements;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    @Override
    public IASTNode removeLastChild() {
        IASTNode removed = this.innerElements.removeLast();
        removed.setParent(null);
        return removed;
    }

    @Override
    public LinkedList<IASTNode> removeChildren() {
        LinkedList<IASTNode> removedChildren = new LinkedList<IASTNode>(this.innerElements);
        for (IASTNode iastNode : removedChildren) {
            iastNode.setParent(null);
        }
        this.innerElements = new LinkedList();
        return removedChildren;
    }

    @Override
    public IContainerAwareNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IContainerAwareNode parent) {
        this.parent = parent;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.innerElements == null ? 0 : this.innerElements.hashCode());
        return result;
    }

    public abstract String toString();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractContainerNode other = (AbstractContainerNode)obj;
        return !(this.innerElements == null ? other.innerElements != null : !CollectionUtils.isEqualCollection(this.innerElements, other.innerElements));
    }

    @Override
    public MELLocation getLocation() {
        if (this.getChildren().isEmpty()) {
            return MELLocation.UNKNOWN_LOCATION;
        }
        MELLocation startLocation = this.getChildren().get(0).getLocation();
        MELLocation endLocation = this.getChildren().get(this.getChildren().size() - 1).getLocation();
        return new MELLocation(startLocation.getColumn() + startLocation.getLength(), startLocation.getOffset(), startLocation.getOffset() - endLocation.getOffset() + endLocation.getLength(), startLocation.getDocument());
    }
}

