/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.autocomplete.mel.view;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.IUpdate;
import org.mule.tooling.core.mel.partitioner.EvaluatorExtensionConfiguration;
import org.mule.tooling.core.mel.partitioner.MELDocumentPartitioner;
import org.mule.tooling.core.utils.IObjectRef;
import org.mule.tooling.ui.modules.core.autocomplete.mel.MELViewerConfiguration;
import org.mule.tooling.ui.widgets.util.WidgetUtils;

public class MELViewer
extends ProjectionViewer {
    private Map<String, IAction> actions = new HashMap<String, IAction>();
    private IObjectRef<EvaluatorExtensionConfiguration> dsConfigurationRef;
    private MELViewerConfiguration melConfiguration;

    public MELViewer(Composite parent, IObjectRef<EvaluatorExtensionConfiguration> configurationRef, int styles) {
        super(parent, null, null, false, styles);
        this.dsConfigurationRef = configurationRef;
        this.configure();
    }

    public void configure() {
        MELViewerConfiguration melConfiguration;
        this.melConfiguration = melConfiguration = new MELViewerConfiguration((IAnnotationModel)new ProjectionAnnotationModel(), this.dsConfigurationRef);
        this.configure(melConfiguration);
        Document document = new Document();
        new MELDocumentPartitioner().connect((IDocument)document);
        this.setDocument((IDocument)document);
        WidgetUtils.addUndoAndRedoCapability((TextViewer)this);
    }

    protected void handleDispose() {
        this.actions.clear();
        super.handleDispose();
    }

    public boolean isActivePopup() {
        return this.melConfiguration.isActivePopup();
    }

    protected void updateActions() {
        for (IAction action : this.actions.values()) {
            if (!(action instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    public String getText() {
        if (this.getDocument() != null) {
            return this.getDocument().get();
        }
        return "";
    }

    public void setText(String input) {
        this.getDocument().set(input);
    }
}

